/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedRandomSwimming;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteStrandedAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleEatAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleIsFreeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhalePunchAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.HumpbackWhaleTailSwipeProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class HumpbackWhaleEntity
extends Animal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_barnacleCount = SynchedEntityData.defineId(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_barnacleGrowCooldown = SynchedEntityData.defineId(HumpbackWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public HumpbackWhaleEntity(EntityType<HumpbackWhaleEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (HumpbackWhaleEntity.this.isInWater()) {
                    HumpbackWhaleEntity.this.setDeltaMovement(HumpbackWhaleEntity.this.getDeltaMovement().add(0.0, -0.0025, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !HumpbackWhaleEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - HumpbackWhaleEntity.this.getX();
                    double dy = this.wantedY - HumpbackWhaleEntity.this.getY();
                    double dz = this.wantedZ - HumpbackWhaleEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * HumpbackWhaleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    HumpbackWhaleEntity.this.setYRot(this.rotlerp(HumpbackWhaleEntity.this.getYRot(), f, 3.0f));
                    HumpbackWhaleEntity.this.yBodyRot = HumpbackWhaleEntity.this.getYRot();
                    HumpbackWhaleEntity.this.yHeadRot = HumpbackWhaleEntity.this.getYRot();
                    if (HumpbackWhaleEntity.this.isInWater()) {
                        HumpbackWhaleEntity.this.setSpeed((float)HumpbackWhaleEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        HumpbackWhaleEntity.this.setXRot(this.rotlerp(HumpbackWhaleEntity.this.getXRot(), f2, 3.0f));
                        float f3 = Mth.cos((float)(HumpbackWhaleEntity.this.getXRot() * ((float)Math.PI / 180)));
                        HumpbackWhaleEntity.this.setZza(f3 * f1);
                        HumpbackWhaleEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        HumpbackWhaleEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    HumpbackWhaleEntity.this.setSpeed(0.0f);
                    HumpbackWhaleEntity.this.setYya(0.0f);
                    HumpbackWhaleEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_barnacleCount, (Object)0);
        builder.define(DATA_barnacleGrowCooldown, (Object)2000);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = HumpbackWhaleEntity.this.getX();
                double y = HumpbackWhaleEntity.this.getY();
                double z = HumpbackWhaleEntity.this.getZ();
                HumpbackWhaleEntity entity = HumpbackWhaleEntity.this;
                Level world = HumpbackWhaleEntity.this.level();
                return super.canUse() && HumpbackWhaleIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal(this, 0.8){

            public boolean canUse() {
                double x = HumpbackWhaleEntity.this.getX();
                double y = HumpbackWhaleEntity.this.getY();
                double z = HumpbackWhaleEntity.this.getZ();
                HumpbackWhaleEntity entity = HumpbackWhaleEntity.this;
                Level world = HumpbackWhaleEntity.this.level();
                return super.canUse() && HumpbackWhaleIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new BreedGoal(this, 0.8){

            public boolean canUse() {
                double x = HumpbackWhaleEntity.this.getX();
                double y = HumpbackWhaleEntity.this.getY();
                double z = HumpbackWhaleEntity.this.getZ();
                HumpbackWhaleEntity entity = HumpbackWhaleEntity.this;
                Level world = HumpbackWhaleEntity.this.level();
                return super.canUse() && HumpbackWhaleIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean canUse() {
                double x = HumpbackWhaleEntity.this.getX();
                double y = HumpbackWhaleEntity.this.getY();
                double z = HumpbackWhaleEntity.this.getZ();
                HumpbackWhaleEntity entity = HumpbackWhaleEntity.this;
                Level world = HumpbackWhaleEntity.this.level();
                return super.canUse() && HumpbackWhaleIsFreeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new AdvancedRandomSwimming((PathfinderMob)this, 1.5, 10, 24, 8, true){

            @Override
            public boolean canUse() {
                double x = HumpbackWhaleEntity.this.getX();
                double y = HumpbackWhaleEntity.this.getY();
                double z = HumpbackWhaleEntity.this.getZ();
                HumpbackWhaleEntity entity = HumpbackWhaleEntity.this;
                Level world = HumpbackWhaleEntity.this.level();
                return super.canUse() && HumpbackWhaleIsFreeProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:humpbackwhale_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:humpbackwhale_death"));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:humpbackwhale_ambient"));
    }

    protected float getSoundVolume() {
        return 3.0f;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        HumpbackWhaleSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("DatabarnacleCount", ((Integer)this.entityData.get(DATA_barnacleCount)).intValue());
        compound.putInt("DatabarnacleGrowCooldown", ((Integer)this.entityData.get(DATA_barnacleGrowCooldown)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DatabarnacleCount")) {
            this.entityData.set(DATA_barnacleCount, (Object)compound.getInt("DatabarnacleCount"));
        }
        if (compound.contains("DatabarnacleGrowCooldown")) {
            this.entityData.set(DATA_barnacleGrowCooldown, (Object)compound.getInt("DatabarnacleGrowCooldown"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        HumpbackWhaleEntity entity = this;
        Level world = this.level();
        HumpbackWhaleRightClickProcedure.execute((LevelAccessor)world, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(HumpbackWhaleEatAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GreatWhiteStrandedAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(HumpbackWhalePunchAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(HumpbackWhaleTailSwipeProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        HumpbackWhaleOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        HumpbackWhaleEntity retval = (HumpbackWhaleEntity)((EntityType)AbyssoulsWildlifeModEntities.HUMPBACK_WHALE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:null"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HumpbackWhaleEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        HumpbackWhaleEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 2.0);
        builder = builder.add(Attributes.MAX_HEALTH, 230.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 20.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 2.0);
        return builder;
    }
}

