/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.BelugaWhaleEntity;
import net.abyssoul.abyssoulswildlife.entity.ElephantSealEntity;
import net.abyssoul.abyssoulswildlife.entity.GreatWhiteEntity;
import net.abyssoul.abyssoulswildlife.entity.HumpbackWhaleEntity;
import net.abyssoul.abyssoulswildlife.entity.TigerSharkEntity;
import net.abyssoul.abyssoulswildlife.entity.WhitetipReefSharkEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.OrcaAIJump;
import net.abyssoul.abyssoulswildlife.entity.ai.SwimmerJumpPathNavigator;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.OrcaBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaOntickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaTailSwipeAnimProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class OrcaEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetx = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targety = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetz = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfx = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfy = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_selfz = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hunger = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(OrcaEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public int jumpCooldown;

    public OrcaEntity(EntityType<OrcaEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveHelperController(this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return !this.isTame();
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    protected float getSoundVolume() {
        return 3.0f;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.93));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.007, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_targetx, (Object)0);
        builder.define(DATA_targety, (Object)0);
        builder.define(DATA_targetz, (Object)0);
        builder.define(DATA_selfx, (Object)0);
        builder.define(DATA_selfy, (Object)0);
        builder.define(DATA_selfz, (Object)0);
        builder.define(DATA_hunger, (Object)20);
        builder.define(DATA_FollowState, (Object)"free");
    }

    protected PathNavigation createNavigation(Level world) {
        return new SwimmerJumpPathNavigator((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, WhitetipReefSharkEntity.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, ElephantSealEntity.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, TigerSharkEntity.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, GreatWhiteEntity.class, 10, true, true, p_28879_ -> {
            TamableAnimal tamable;
            return p_28879_ instanceof TamableAnimal && !(tamable = (TamableAnimal)p_28879_).isTame();
        }){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, BelugaWhaleEntity.class, 10, true, true, p_28879_ -> {
            TamableAnimal tamable;
            return p_28879_ instanceof TamableAnimal && !(tamable = (TamableAnimal)p_28879_).isTame();
        }){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, HumpbackWhaleEntity.class, true, true){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new FollowParentGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new BreedGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(1, (Goal)new OrcaAIJump(this, 10){

            @Override
            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.8, 10){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 9.0f){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = OrcaEntity.this.getX();
                double y = OrcaEntity.this.getY();
                double z = OrcaEntity.this.getZ();
                OrcaEntity entity = OrcaEntity.this;
                Level world = OrcaEntity.this.level();
                return super.canUse() && OrcaFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:orca_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:orca_death"));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:orca_ambient"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("Datatargetx", ((Integer)this.entityData.get(DATA_targetx)).intValue());
        compound.putInt("Datatargety", ((Integer)this.entityData.get(DATA_targety)).intValue());
        compound.putInt("Datatargetz", ((Integer)this.entityData.get(DATA_targetz)).intValue());
        compound.putInt("Dataselfx", ((Integer)this.entityData.get(DATA_selfx)).intValue());
        compound.putInt("Dataselfy", ((Integer)this.entityData.get(DATA_selfy)).intValue());
        compound.putInt("Dataselfz", ((Integer)this.entityData.get(DATA_selfz)).intValue());
        compound.putInt("Datahunger", ((Integer)this.entityData.get(DATA_hunger)).intValue());
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("Datatargetx")) {
            this.entityData.set(DATA_targetx, (Object)compound.getInt("Datatargetx"));
        }
        if (compound.contains("Datatargety")) {
            this.entityData.set(DATA_targety, (Object)compound.getInt("Datatargety"));
        }
        if (compound.contains("Datatargetz")) {
            this.entityData.set(DATA_targetz, (Object)compound.getInt("Datatargetz"));
        }
        if (compound.contains("Dataselfx")) {
            this.entityData.set(DATA_selfx, (Object)compound.getInt("Dataselfx"));
        }
        if (compound.contains("Dataselfy")) {
            this.entityData.set(DATA_selfy, (Object)compound.getInt("Dataselfy"));
        }
        if (compound.contains("Dataselfz")) {
            this.entityData.set(DATA_selfz, (Object)compound.getInt("Dataselfz"));
        }
        if (compound.contains("Datahunger")) {
            this.entityData.set(DATA_hunger, (Object)compound.getInt("Datahunger"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        OrcaEntity entity = this;
                        Level world = this.level();
                        return OrcaRightClickProcedure.execute(x, y, z, (Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        OrcaKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
            float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
            this.setXRot(f2);
        }
        if (!this.isUnderWater() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.3f), 0.7, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.3f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (this.level().isClientSide && this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.03) {
            Vec3 vector3d = this.getViewVector(0.0f);
            float yRotRad = this.getYRot() * ((float)Math.PI / 180);
            float f = Mth.cos((float)yRotRad) * 0.9f;
            float f1 = Mth.sin((float)yRotRad) * 0.9f;
            float f2 = 1.2f - this.random.nextFloat() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f, this.getY() - vector3d.y, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(OrcaBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(OrcaChargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(OrcaTailSwipeAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        OrcaOntickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        OrcaEntity retval = (OrcaEntity)((EntityType)AbyssoulsWildlifeModEntities.ORCA.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.GUARDIAN_MEAT.get())}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OrcaEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OrcaEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.5);
        builder = builder.add(Attributes.MAX_HEALTH, 150.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 15.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }

    static class MoveHelperController
    extends MoveControl {
        private final OrcaEntity dolphin;

        public MoveHelperController(OrcaEntity dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void tick() {
            if (this.dolphin.isInWater()) {
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.dolphin.getNavigation().isDone()) {
                double d2;
                double d1;
                double d0 = this.wantedX - this.dolphin.getX();
                double d3 = d0 * d0 + (d1 = this.wantedY - this.dolphin.getY()) * d1 + (d2 = this.wantedZ - this.dolphin.getZ()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.setYRot(this.rotlerp(this.dolphin.getYRot(), f, 8.0f));
                    this.dolphin.yBodyRot = this.dolphin.getYRot() + 0.5f;
                    this.dolphin.yHeadRot = this.dolphin.getYRot();
                    float f1 = (float)(this.speedModifier * this.dolphin.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    if (this.dolphin.isInWater()) {
                        this.dolphin.setSpeed(f1 * 0.02f);
                        float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.setXRot(this.rotlerp(this.dolphin.getXRot(), f2, 10.0f));
                        float xRotRad = this.dolphin.getXRot() * ((float)Math.PI / 180);
                        float f3 = Mth.cos((float)xRotRad);
                        float f4 = Mth.sin((float)xRotRad);
                        this.dolphin.zza = f3 * f1;
                        this.dolphin.yya = -f4 * f1;
                    } else {
                        this.dolphin.setSpeed(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.setSpeed(0.0f);
                this.dolphin.setXxa(0.0f);
                this.dolphin.setYya(0.0f);
                this.dolphin.setZza(0.0f);
            }
        }
    }
}

