/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerAttackAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerIsFollowingOwnerProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerNoAntlerProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.ReindeerRightClickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ReindeerEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_haveantlertime = SynchedEntityData.defineId(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    private ReindeerEntity leader;

    public ReindeerEntity(EntityType<ReindeerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_haveantlertime, (Object)12000);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal(this, (PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                LivingEntity livingentity = this.mob.getLastHurtByMob();
                return super.canUse() && livingentity.getMaxHealth() < 20.0f;
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 32.0f, 2.0, 2.0, p_28879_ -> p_28879_ == this.getLastHurtByMob()){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal<PolarBear>((PathfinderMob)this, PolarBear.class, 24.0f, 1.0, 2.0){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal<Wolf>((PathfinderMob)this, Wolf.class, 24.0f, 1.0, 2.0){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(6, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowOwnerGoal(this, 1.3, 10.0f, 2.0f){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerIsFollowingOwnerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FollowMobGoal((Mob)this, 1.3, 81.0f, 900.0f){

            @Override
            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(12, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 30){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                ReindeerEntity entity = ReindeerEntity.this;
                return super.canUse() && ReindeerFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new FloatGoal((Mob)this));
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.isAlive();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.4f, 0.0);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:reindeer_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:reindeer_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:reindeer_death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("Datahaveantlertime", ((Integer)this.entityData.get(DATA_haveantlertime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("Datahaveantlertime")) {
            this.entityData.set(DATA_haveantlertime, (Object)compound.getInt("Datahaveantlertime"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        if (!this.isBaby()) {
                            sourceentity.startRiding((Entity)this);
                        }
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        ReindeerEntity entity = this;
                        Level world = this.level();
                        return ReindeerRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(6) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(ReindeerAttackAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(ReindeerNoAntlerProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        ReindeerOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        ReindeerEntity retval = (ReindeerEntity)((EntityType)AbyssoulsWildlifeModEntities.REINDEER.get()).create((Level)serverWorld);
        retval.getEntityData().set(DATA_haveantlertime, (Object)Mth.nextInt((RandomSource)RandomSource.create(), (int)9000, (int)36000));
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:small_flowers"))).test(stack);
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            return;
        }
        super.travel(dir);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 20.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }

    static class FollowMobGoal
    extends Goal {
        private final Mob mob;
        private final Predicate<Mob> followPredicate;
        @Nullable
        private Mob followingMob;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public FollowMobGoal(Mob p_25271_, double p_25272_, float p_25273_, float p_25274_) {
            this.mob = p_25271_;
            this.followPredicate = p_25278_ -> p_25278_ != null && p_25271_.getClass() == p_25278_.getClass();
            this.speedModifier = p_25272_;
            this.navigation = p_25271_.getNavigation();
            this.stopDistance = p_25273_;
            this.areaSize = p_25274_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(p_25271_.getNavigation() instanceof GroundPathNavigation) && !(p_25271_.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
            }
        }

        public boolean canUse() {
            List list = this.mob.level().getEntitiesOfClass(Mob.class, this.mob.getBoundingBox().inflate((double)this.areaSize), this.followPredicate);
            if (!list.isEmpty()) {
                for (Mob mob : list) {
                    if (!(mob instanceof ReindeerEntity)) continue;
                    ReindeerEntity tofollow = (ReindeerEntity)mob;
                    Mob mob2 = this.mob;
                    if (!(mob2 instanceof ReindeerEntity)) continue;
                    ReindeerEntity follower = (ReindeerEntity)mob2;
                    if (mob.isInvisible() || follower == tofollow.leader || tofollow.isFollower() || !(this.mob.distanceToSqr((Entity)mob) < (double)this.areaSize) || !(this.mob.distanceToSqr((Entity)mob) > (double)this.stopDistance) || this.followingMob != null) continue;
                    this.followingMob = mob;
                    follower.leader = tofollow;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.followingMob != null && !this.navigation.isDone() && this.mob.distanceToSqr((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
            this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.followingMob = null;
            this.navigation.stop();
            this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            if (this.followingMob != null && !this.mob.isLeashed()) {
                this.mob.getLookControl().setLookAt((Entity)this.followingMob, 10.0f, (float)this.mob.getMaxHeadXRot());
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = this.adjustedTickDelay(10);
                    double d0 = this.mob.getX() - this.followingMob.getX();
                    double d3 = d0 * d0 + (d1 = this.mob.getY() - this.followingMob.getY()) * d1 + (d2 = this.mob.getZ() - this.followingMob.getZ()) * d2;
                    if (!(d3 >= (double)(this.stopDistance * this.stopDistance))) {
                        this.navigation.moveTo((Entity)this.followingMob, this.speedModifier);
                    } else {
                        this.navigation.stop();
                        LookControl lookcontrol = this.followingMob.getLookControl();
                        if (d3 <= (double)this.stopDistance || lookcontrol.getWantedX() == this.mob.getX() && lookcontrol.getWantedY() == this.mob.getY() && lookcontrol.getWantedZ() == this.mob.getZ()) {
                            double d4 = this.followingMob.getX() - this.mob.getX();
                            double d5 = this.followingMob.getZ() - this.mob.getZ();
                            this.navigation.moveTo(this.mob.getX() - d4, this.mob.getY(), this.mob.getZ() - d5, this.speedModifier);
                        }
                    }
                }
            }
        }
    }
}

