/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ai.CustomPathNavigateGround;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoAttack2AnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoAttackAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoFollowStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoIsIndianProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoShakeheadAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.RhinoSpawnProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RhinoEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(RhinoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(RhinoEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(RhinoEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_IsIndian = SynchedEntityData.defineId(RhinoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();

    public RhinoEntity(EntityType<RhinoEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_FollowState, (Object)"free");
        builder.define(DATA_IsIndian, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new CustomPathNavigateGround((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                RhinoEntity entity = RhinoEntity.this;
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal(this, 1.5, 10.0f, 2.0f){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFollowStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = RhinoEntity.this.getX();
                double y = RhinoEntity.this.getY();
                double z = RhinoEntity.this.getZ();
                RhinoEntity entity = RhinoEntity.this;
                Level world = RhinoEntity.this.level();
                return super.canUse() && RhinoFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        if ((Integer)this.getEntityData().get(DATA_IsIndian) == 1) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_indian_ambient"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        if ((Integer)this.getEntityData().get(DATA_IsIndian) == 1) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_indian_hurt"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_hurt"));
    }

    public SoundEvent getDeathSound() {
        if ((Integer)this.getEntityData().get(DATA_IsIndian) == 1) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_indian_death"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:rhino_death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        if (reason != MobSpawnType.BREEDING) {
            RhinoSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        }
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
        compound.putInt("DataIsIndian", ((Integer)this.entityData.get(DATA_IsIndian)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
        if (compound.contains("DataIsIndian")) {
            this.entityData.set(DATA_IsIndian, (Object)compound.getInt("DataIsIndian"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        if (!this.isBaby()) {
                            sourceentity.startRiding((Entity)this);
                        }
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        RhinoEntity entity = this;
                        Level world = this.level();
                        return RhinoRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(12) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(RhinoAttackAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(RhinoAttack2AnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(RhinoChargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(RhinoIsIndianProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(RhinoShakeheadAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        RhinoOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        if (this.getEntityData().get(DATA_IsIndian) == ageable.getEntityData().get(DATA_IsIndian) || ageable == null) {
            RhinoEntity retval = (RhinoEntity)((EntityType)AbyssoulsWildlifeModEntities.RHINO.get()).create((Level)serverWorld);
            retval.getEntityData().set(DATA_IsIndian, (Object)((Integer)this.getEntityData().get(DATA_IsIndian)));
            retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
            return retval;
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.HAY_BLOCK)}).test(stack);
    }

    public void travel(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
        if (this.isVehicle()) {
            this.setYRot(entity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(entity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yBodyRot = entity.getYRot();
            this.yHeadRot = entity.getYRot();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float forward = passenger.zza;
                float strafe = passenger.xxa;
                super.travel(new Vec3((double)strafe, 0.0, (double)forward));
            }
            return;
        }
        super.travel(dir);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.24);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        return builder;
    }
}

