/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedFindWater;
import net.abyssoul.abyssoulswildlife.entity.ai.CustomPathNavigateGround;
import net.abyssoul.abyssoulswildlife.entity.ai.LeaveWaterGoal;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModBlocks;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.CrocodileOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.CrocodileRightClickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.CrocodileSizeProcedure;
import net.abyssoul.abyssoulswildlife.procedures.CrocodileSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.IsBabyProcedure;
import net.abyssoul.abyssoulswildlife.procedures.JaguarKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.NeedOxygenProcedure;
import net.abyssoul.abyssoulswildlife.procedures.OrcaIsnotTamedProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileDeathrollAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SaltwaterCrocodileTailswipeAnimProcedure;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class SaltwaterCrocodileEntity
extends TamableAnimal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(SaltwaterCrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(SaltwaterCrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_IsLord = SynchedEntityData.defineId(SaltwaterCrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_skintype = SynchedEntityData.defineId(SaltwaterCrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_FollowState = SynchedEntityData.defineId(SaltwaterCrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    private boolean isLandNavigator;
    private int swimTimer = 0;

    public SaltwaterCrocodileEntity(EntityType<SaltwaterCrocodileEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.switchNavigator(false);
        this.setPersistenceRequired();
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.moveControl = new MoveControl((Mob)this);
            PathNavigation prevNav = this.navigation;
            this.navigation = new CustomPathNavigateGround((Mob)this, this.level());
            this.isLandNavigator = true;
            this.lookControl = new LookControl((Mob)this);
        } else {
            this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 12, 10, 1.0f, 2.0f, false);
            PathNavigation prevNav = this.navigation;
            this.navigation = new WaterBoundPathNavigation((Mob)this, this.level());
            this.isLandNavigator = false;
            this.lookControl = new SmoothSwimmingLookControl((Mob)this, 0);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_IsLord, (Object)0);
        builder.define(DATA_skintype, (Object)0);
        builder.define(DATA_FollowState, (Object)"free");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && IsBabyProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new LeaveWaterGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                return super.canUse() && SaltwaterCrocodileEntity.this.swimTimer > 1200 && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(5, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, true, true){

            public boolean canUse() {
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, true, true){

            public boolean canUse() {
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, true, true){

            public boolean canUse() {
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, true, true){

            public boolean canUse() {
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                return super.canUse() && OrcaIsnotTamedProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new FollowParentGoal((Animal)this, 0.8){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(10, (Goal)new BreedGoal((Animal)this, 1.0){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(11, (Goal)new AdvancedFindWater((PathfinderMob)this){

            @Override
            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity) && SaltwaterCrocodileEntity.this.swimTimer < -200;
            }
        });
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && SaltwaterCrocodileFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(16, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = SaltwaterCrocodileEntity.this.getX();
                double y = SaltwaterCrocodileEntity.this.getY();
                double z = SaltwaterCrocodileEntity.this.getZ();
                SaltwaterCrocodileEntity entity = SaltwaterCrocodileEntity.this;
                Level world = SaltwaterCrocodileEntity.this.level();
                return super.canUse() && NeedOxygenProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        if (this.isBaby()) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_baby"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        if (this.isBaby()) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_baby"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_hurt"));
    }

    public SoundEvent getDeathSound() {
        if (this.isBaby()) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_baby"));
        }
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:crocodile_death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        CrocodileSpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("DataIsLord", ((Integer)this.entityData.get(DATA_IsLord)).intValue());
        compound.putInt("Dataskintype", ((Integer)this.entityData.get(DATA_skintype)).intValue());
        compound.putString("DataFollowState", (String)this.entityData.get(DATA_FollowState));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataIsLord")) {
            this.entityData.set(DATA_IsLord, (Object)compound.getInt("DataIsLord"));
        }
        if (compound.contains("Dataskintype")) {
            this.entityData.set(DATA_skintype, (Object)compound.getInt("Dataskintype"));
        }
        if (compound.contains("DataFollowState")) {
            this.entityData.set(DATA_FollowState, (Object)compound.getString("DataFollowState"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    if (itemstack.getItem() == AbyssoulsWildlifeModItems.LARGE_BEAST_BONE.get() && (Integer)this.getEntityData().get(DATA_IsLord) == 0 && !this.isBaby()) {
                        this.getEntityData().set(DATA_IsLord, (Object)1);
                        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(75.0);
                        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(10.0);
                        this.setHealth((float)this.getAttribute(Attributes.MAX_HEALTH).getValue());
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        Level world = this.level();
                        if (world instanceof Level) {
                            Level _level = world;
                            if (!_level.isClientSide()) {
                                _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie_villager.cure")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                            } else {
                                _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.zombie_villager.cure")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                            }
                        }
                        this.usePlayerItem(sourceentity, hand, itemstack);
                        if (sourceentity instanceof ServerPlayer) {
                            AdvancementProgress _ap;
                            ServerPlayer _player = (ServerPlayer)sourceentity;
                            AdvancementHolder _adv = _player.server.getAdvancements().get(ResourceLocation.parse((String)"abyssouls_wildlife:gator_man"));
                            if (_adv != null && !(_ap = _player.getAdvancements().getOrStartProgress(_adv)).isDone()) {
                                for (String criteria : _ap.getRemainingCriteria()) {
                                    _player.getAdvancements().award(_adv, criteria);
                                }
                            }
                        }
                        retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                        return retval;
                    }
                    retval = super.mobInteract(sourceentity, hand);
                    if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                        double x = this.getX();
                        double y = this.getY();
                        double z = this.getZ();
                        SaltwaterCrocodileEntity entity = this;
                        Level world = this.level();
                        return CrocodileRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
                    }
                }
            }
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        JaguarKillOtherProcedure.execute((Entity)this);
    }

    public void tick() {
        boolean ground;
        super.tick();
        boolean bl = ground = !this.isInWater();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (!this.level().isClientSide) {
            this.swimTimer = this.isInWater() ? ++this.swimTimer : --this.swimTimer;
        }
        if (this.level().isClientSide()) {
            this.animationState2.animateWhen(SaltwaterCrocodileBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(IsBabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(SaltwaterCrocodileTailswipeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(SaltwaterCrocodileDeathrollAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        CrocodileOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        if (ageable == null || ageable == this) {
            SaltwaterCrocodileEntity retval = (SaltwaterCrocodileEntity)((EntityType)AbyssoulsWildlifeModEntities.SALTWATER_CROCODILE.get()).create((Level)serverWorld);
            retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
            return retval;
        }
        serverWorld.playSound(null, this.blockPosition(), SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + serverWorld.random.nextFloat() * 0.2f);
        serverWorld.setBlock(this.blockPosition().above(), ((Block)AbyssoulsWildlifeModBlocks.SALTWATER_CROCODILE_EGG.get()).defaultBlockState(), 3);
        SaltwaterCrocodileEntity saltwaterCrocodileEntity = this;
        if (saltwaterCrocodileEntity instanceof Animal) {
            SaltwaterCrocodileEntity ani1 = saltwaterCrocodileEntity;
            if (ageable instanceof Animal) {
                Animal ani2 = (Animal)ageable;
                ani1.resetLove();
                ani2.resetLove();
                ani1.setInLoveTime(0);
                ani2.setInLoveTime(0);
            }
        }
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:meat"))).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        SaltwaterCrocodileEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)CrocodileSizeProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.5);
        return builder;
    }
}

