/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import net.abyssoul.abyssoulswildlife.entity.HerculodonEntity;
import net.abyssoul.abyssoulswildlife.procedures.SeablueGuardianTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class SeablueGuardianEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_launchtime = SynchedEntityData.defineId(SeablueGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_lefttime = SynchedEntityData.defineId(SeablueGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public SeablueGuardianEntity(EntityType<SeablueGuardianEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (SeablueGuardianEntity.this.isInWater()) {
                    SeablueGuardianEntity.this.setDeltaMovement(SeablueGuardianEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !SeablueGuardianEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - SeablueGuardianEntity.this.getX();
                    double dy = this.wantedY - SeablueGuardianEntity.this.getY();
                    double dz = this.wantedZ - SeablueGuardianEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * SeablueGuardianEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    SeablueGuardianEntity.this.setYRot(this.rotlerp(SeablueGuardianEntity.this.getYRot(), f, 10.0f));
                    SeablueGuardianEntity.this.yBodyRot = SeablueGuardianEntity.this.getYRot();
                    SeablueGuardianEntity.this.yHeadRot = SeablueGuardianEntity.this.getYRot();
                    if (SeablueGuardianEntity.this.isInWater()) {
                        SeablueGuardianEntity.this.setSpeed((float)SeablueGuardianEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        SeablueGuardianEntity.this.setXRot(this.rotlerp(SeablueGuardianEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(SeablueGuardianEntity.this.getXRot() * ((float)Math.PI / 180)));
                        SeablueGuardianEntity.this.setZza(f3 * f1);
                        SeablueGuardianEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        SeablueGuardianEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    SeablueGuardianEntity.this.setSpeed(0.0f);
                    SeablueGuardianEntity.this.setYya(0.0f);
                    SeablueGuardianEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_launchtime, (Object)0);
        builder.define(DATA_lefttime, (Object)3);
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datalaunchtime", ((Integer)this.entityData.get(DATA_launchtime)).intValue());
        compound.putInt("Datalefttime", ((Integer)this.entityData.get(DATA_lefttime)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datalaunchtime")) {
            this.entityData.set(DATA_launchtime, (Object)compound.getInt("Datalaunchtime"));
        }
        if (compound.contains("Datalefttime")) {
            this.entityData.set(DATA_lefttime, (Object)compound.getInt("Datalefttime"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
        }
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getEntity() instanceof HerculodonEntity || damagesource.getEntity() instanceof SeablueGuardianEntity) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void baseTick() {
        super.baseTick();
        SeablueGuardianTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SeablueGuardianEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SeablueGuardianEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 35.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.3);
        return builder;
    }
}

