/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.entity.ColossalSquidEntity;
import net.abyssoul.abyssoulswildlife.entity.ai.AdvancedRandomSwimming;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteStrandedAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleChargeAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleHeadPunchAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleOnTickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleSpawnProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SpermWhaleTailSwipeAnimProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class SpermWhaleEntity
extends Animal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetx = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targety = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_targetz = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_skintype = SynchedEntityData.defineId(SpermWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public SpermWhaleEntity(EntityType<SpermWhaleEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveHelperController(this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_targetx, (Object)0);
        builder.define(DATA_targety, (Object)0);
        builder.define(DATA_targetz, (Object)0);
        builder.define(DATA_skintype, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ColossalSquidEntity.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true, true));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = SpermWhaleEntity.this.getX();
                double y = SpermWhaleEntity.this.getY();
                double z = SpermWhaleEntity.this.getZ();
                SpermWhaleEntity entity = SpermWhaleEntity.this;
                Level world = SpermWhaleEntity.this.level();
                return super.canUse() && SpermWhaleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal(this, 0.8){

            public boolean canUse() {
                double x = SpermWhaleEntity.this.getX();
                double y = SpermWhaleEntity.this.getY();
                double z = SpermWhaleEntity.this.getZ();
                SpermWhaleEntity entity = SpermWhaleEntity.this;
                Level world = SpermWhaleEntity.this.level();
                return super.canUse() && SpermWhaleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new BreedGoal(this, 0.8){

            public boolean canUse() {
                double x = SpermWhaleEntity.this.getX();
                double y = SpermWhaleEntity.this.getY();
                double z = SpermWhaleEntity.this.getZ();
                SpermWhaleEntity entity = SpermWhaleEntity.this;
                Level world = SpermWhaleEntity.this.level();
                return super.canUse() && SpermWhaleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f){

            public boolean canUse() {
                double x = SpermWhaleEntity.this.getX();
                double y = SpermWhaleEntity.this.getY();
                double z = SpermWhaleEntity.this.getZ();
                SpermWhaleEntity entity = SpermWhaleEntity.this;
                Level world = SpermWhaleEntity.this.level();
                return super.canUse() && SpermWhaleFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new AdvancedRandomSwimming((PathfinderMob)this, 0.8, 5, 48, 7, true){

            @Override
            public boolean canUse() {
                double x = SpermWhaleEntity.this.getX();
                double y = SpermWhaleEntity.this.getY();
                double z = SpermWhaleEntity.this.getZ();
                SpermWhaleEntity entity = SpermWhaleEntity.this;
                Level world = SpermWhaleEntity.this.level();
                return super.canUse() && SpermWhaleFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:spermwhale_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:spermwhale_death"));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:spermwhale_ambient"));
    }

    protected float getSoundVolume() {
        return 4.0f;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        SpermWhaleSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("Datatargetx", ((Integer)this.entityData.get(DATA_targetx)).intValue());
        compound.putInt("Datatargety", ((Integer)this.entityData.get(DATA_targety)).intValue());
        compound.putInt("Datatargetz", ((Integer)this.entityData.get(DATA_targetz)).intValue());
        compound.putInt("Dataskintype", ((Integer)this.entityData.get(DATA_skintype)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("Datatargetx")) {
            this.entityData.set(DATA_targetx, (Object)compound.getInt("Datatargetx"));
        }
        if (compound.contains("Datatargety")) {
            this.entityData.set(DATA_targety, (Object)compound.getInt("Datatargety"));
        }
        if (compound.contains("Datatargetz")) {
            this.entityData.set(DATA_targetz, (Object)compound.getInt("Datatargetz"));
        }
        if (compound.contains("Dataskintype")) {
            this.entityData.set(DATA_skintype, (Object)compound.getInt("Dataskintype"));
        }
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        SpermWhaleKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(SpermWhaleBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GreatWhiteStrandedAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(SpermWhaleChargeAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(SpermWhaleHeadPunchAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(SpermWhaleTailSwipeAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SpermWhaleOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        SpermWhaleEntity retval = (SpermWhaleEntity)((EntityType)AbyssoulsWildlifeModEntities.SPERM_WHALE.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:null"))).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SpermWhaleEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SpermWhaleEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.5);
        builder = builder.add(Attributes.MAX_HEALTH, 300.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 25.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 3.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }

    static class MoveHelperController
    extends MoveControl {
        private final SpermWhaleEntity dolphin;

        public MoveHelperController(SpermWhaleEntity dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void tick() {
            if (this.dolphin.isInWater()) {
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.dolphin.getNavigation().isDone()) {
                double d2;
                double d1;
                double d0 = this.wantedX - this.dolphin.getX();
                double d3 = d0 * d0 + (d1 = this.wantedY - this.dolphin.getY()) * d1 + (d2 = this.wantedZ - this.dolphin.getZ()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.setYRot(this.rotlerp(this.dolphin.getYRot(), f, 3.0f));
                    this.dolphin.yBodyRot = 0.5f * (this.dolphin.getYRot() + 0.5f);
                    this.dolphin.yHeadRot = this.dolphin.getYRot();
                    float f1 = (float)(this.speedModifier * this.dolphin.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    if (this.dolphin.isInWater()) {
                        this.dolphin.setSpeed(f1 * 0.05f);
                        float f2 = -((float)(Mth.atan2((double)d1, (double)Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.setXRot(this.rotlerp(this.dolphin.getXRot(), f2, 5.0f));
                        float xRotRad = this.dolphin.getXRot() * ((float)Math.PI / 180);
                        float f3 = Mth.cos((float)xRotRad);
                        float f4 = Mth.sin((float)xRotRad);
                        this.dolphin.zza = f3 * f1;
                        this.dolphin.yya = -f4 * f1;
                    } else {
                        this.dolphin.setSpeed(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.setSpeed(0.0f);
                this.dolphin.setXxa(0.0f);
                this.dolphin.setYya(0.0f);
                this.dolphin.setZza(0.0f);
            }
        }
    }
}

