/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.abyssoul.abyssoulswildlife.AbyssoulsWildlifeMod;
import net.abyssoul.abyssoulswildlife.entity.OrcaEntity;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.GreatWhiteStrandedAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkFreeStateProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkIshungryProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkKillOtherProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkOntickProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkScaleProcedure;
import net.abyssoul.abyssoulswildlife.procedures.TigerSharkSpawnProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class TigerSharkEntity
extends Animal {
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(TigerSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(TigerSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hunger = SynchedEntityData.defineId(TigerSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_skintype = SynchedEntityData.defineId(TigerSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_Scale = SynchedEntityData.defineId(TigerSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public TigerSharkEntity(EntityType<TigerSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (TigerSharkEntity.this.isInWater()) {
                    TigerSharkEntity.this.setDeltaMovement(TigerSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !TigerSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - TigerSharkEntity.this.getX();
                    double dy = this.wantedY - TigerSharkEntity.this.getY();
                    double dz = this.wantedZ - TigerSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * TigerSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    TigerSharkEntity.this.setYRot(this.rotlerp(TigerSharkEntity.this.getYRot(), f, 10.0f));
                    TigerSharkEntity.this.yBodyRot = TigerSharkEntity.this.getYRot();
                    TigerSharkEntity.this.yHeadRot = TigerSharkEntity.this.getYRot();
                    if (TigerSharkEntity.this.isInWater()) {
                        TigerSharkEntity.this.setSpeed((float)TigerSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        TigerSharkEntity.this.setXRot(this.rotlerp(TigerSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(TigerSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        TigerSharkEntity.this.setZza(f3 * f1);
                        TigerSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        TigerSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    TigerSharkEntity.this.setSpeed(0.0f);
                    TigerSharkEntity.this.setYya(0.0f);
                    TigerSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CurrentAction, (Object)"free");
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_hunger, (Object)20);
        builder.define(DATA_skintype, (Object)0);
        builder.define(DATA_Scale, (Object)1);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, true){

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkIshungryProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, OrcaEntity.class, 32.0f, 1.0, 0.8));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal(this, 1.0){

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.TURTLE_EGG.asItem()}), false){

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 40){

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkFreeStateProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = TigerSharkEntity.this.getX();
                double y = TigerSharkEntity.this.getY();
                double z = TigerSharkEntity.this.getZ();
                TigerSharkEntity entity = TigerSharkEntity.this;
                Level world = TigerSharkEntity.this.level();
                return super.canUse() && TigerSharkFreeStateProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        TigerSharkSpawnProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putInt("Datahunger", ((Integer)this.entityData.get(DATA_hunger)).intValue());
        compound.putInt("Dataskintype", ((Integer)this.entityData.get(DATA_skintype)).intValue());
        compound.putInt("DataScale", ((Integer)this.entityData.get(DATA_Scale)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("Datahunger")) {
            this.entityData.set(DATA_hunger, (Object)compound.getInt("Datahunger"));
        }
        if (compound.contains("Dataskintype")) {
            this.entityData.set(DATA_skintype, (Object)compound.getInt("Dataskintype"));
        }
        if (compound.contains("DataScale")) {
            this.entityData.set(DATA_Scale, (Object)compound.getInt("DataScale"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        if (this.isFood(itemstack)) {
            super.mobInteract(sourceentity, hand);
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = InteractionResult.PASS;
            super.mobInteract(sourceentity, hand);
            if (retval != InteractionResult.SUCCESS && retval != InteractionResult.CONSUME) {
                double x = this.getX();
                double y = this.getY();
                double z = this.getZ();
                Level world = this.level();
                if (((String)this.getEntityData().get(DATA_CurrentAction)).equals("free") && itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:fishes")))) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    if (world instanceof Level) {
                        Level _level = world;
                        if (!_level.isClientSide()) {
                            _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.eat")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        } else {
                            _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.eat")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                        }
                    }
                    this.getEntityData().set(DATA_CurrentAction, (Object)"bite");
                    this.getEntityData().set(DATA_ActionTime, (Object)100);
                    AbyssoulsWildlifeMod.queueServerWork(80, () -> {
                        if (Math.random() < (double)((float)((Integer)this.getEntityData().get(DATA_Scale) + 4) / 15.0f)) {
                            if (!world.isClientSide() && world.getServer() != null) {
                                for (ItemStack itemstackiterator : world.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)"abyssouls_wildlife:gameplay/tigershark_reward"))).getRandomItems(new LootParams.Builder((ServerLevel)world).create(LootContextParamSets.EMPTY))) {
                                    if (!(world instanceof ServerLevel)) continue;
                                    ServerLevel _level = (ServerLevel)world;
                                    ItemEntity entityToSpawn = new ItemEntity((Level)_level, x + this.getLookAngle().x, y + 0.3, z + this.getLookAngle().z, itemstackiterator);
                                    entityToSpawn.setPickUpDelay(10);
                                    _level.addFreshEntity((Entity)entityToSpawn);
                                }
                            }
                            if (world instanceof Level) {
                                Level _level = world;
                                if (!_level.isClientSide()) {
                                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.burp")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                                } else {
                                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.burp")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                                }
                            }
                        } else if (world instanceof ServerLevel) {
                            ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y + 0.4, z, 15, 1.5, 1.5, 1.5, 0.0);
                        }
                    });
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
            }
        }
        return retval;
    }

    public void awardKillScore(Entity entity, int score, DamageSource damageSource) {
        super.awardKillScore(entity, score, damageSource);
        TigerSharkKillOtherProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(TigerSharkBiteAnimProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GreatWhiteStrandedAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        TigerSharkOntickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        TigerSharkEntity retval = (TigerSharkEntity)((EntityType)AbyssoulsWildlifeModEntities.TIGER_SHARK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.TURTLE_EGG)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TigerSharkEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TigerSharkEntity entity = this;
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        TigerSharkEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)TigerSharkScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.5);
        builder = builder.add(Attributes.MAX_HEALTH, 50.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.7);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.0);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.5);
        return builder;
    }
}

