/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.function.Predicate;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.procedures.IsNightProcedure;
import net.abyssoul.abyssoulswildlife.procedures.WhitetipReefSharkBiteAnimProcedure;
import net.abyssoul.abyssoulswildlife.procedures.WhitetipReefSharkOnTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class WhitetipReefSharkEntity
extends Animal {
    public static final EntityDataAccessor<Integer> DATA_ActionTime = SynchedEntityData.defineId(WhitetipReefSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_CurrentAction = SynchedEntityData.defineId(WhitetipReefSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState1 = new AnimationState();

    public WhitetipReefSharkEntity(EntityType<WhitetipReefSharkEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (WhitetipReefSharkEntity.this.isInWater()) {
                    WhitetipReefSharkEntity.this.setDeltaMovement(WhitetipReefSharkEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !WhitetipReefSharkEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - WhitetipReefSharkEntity.this.getX();
                    double dy = this.wantedY - WhitetipReefSharkEntity.this.getY();
                    double dz = this.wantedZ - WhitetipReefSharkEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * WhitetipReefSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    WhitetipReefSharkEntity.this.setYRot(this.rotlerp(WhitetipReefSharkEntity.this.getYRot(), f, 10.0f));
                    WhitetipReefSharkEntity.this.yBodyRot = WhitetipReefSharkEntity.this.getYRot();
                    WhitetipReefSharkEntity.this.yHeadRot = WhitetipReefSharkEntity.this.getYRot();
                    if (WhitetipReefSharkEntity.this.isInWater()) {
                        WhitetipReefSharkEntity.this.setSpeed((float)WhitetipReefSharkEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        WhitetipReefSharkEntity.this.setXRot(this.rotlerp(WhitetipReefSharkEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(WhitetipReefSharkEntity.this.getXRot() * ((float)Math.PI / 180)));
                        WhitetipReefSharkEntity.this.setZza(f3 * f1);
                        WhitetipReefSharkEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        WhitetipReefSharkEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    WhitetipReefSharkEntity.this.setSpeed(0.0f);
                    WhitetipReefSharkEntity.this.setYya(0.0f);
                    WhitetipReefSharkEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ActionTime, (Object)0);
        builder.define(DATA_CurrentAction, (Object)"free");
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 0.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, true, true){

            public boolean canUse() {
                double x = WhitetipReefSharkEntity.this.getX();
                double y = WhitetipReefSharkEntity.this.getY();
                double z = WhitetipReefSharkEntity.this.getZ();
                WhitetipReefSharkEntity entity = WhitetipReefSharkEntity.this;
                Level world = WhitetipReefSharkEntity.this.level();
                return super.canUse() && IsNightProcedure.execute((LevelAccessor)world);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true, true){

            public boolean canUse() {
                double x = WhitetipReefSharkEntity.this.getX();
                double y = WhitetipReefSharkEntity.this.getY();
                double z = WhitetipReefSharkEntity.this.getZ();
                WhitetipReefSharkEntity entity = WhitetipReefSharkEntity.this;
                Level world = WhitetipReefSharkEntity.this.level();
                return super.canUse() && IsNightProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH}), false));
        this.goalSelector.addGoal(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.7, 40){

            public boolean canUse() {
                double x = WhitetipReefSharkEntity.this.getX();
                double y = WhitetipReefSharkEntity.this.getY();
                double z = WhitetipReefSharkEntity.this.getZ();
                WhitetipReefSharkEntity entity = WhitetipReefSharkEntity.this;
                Level world = WhitetipReefSharkEntity.this.level();
                return super.canUse() && IsNightProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 40));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = WhitetipReefSharkEntity.this.getX();
                double y = WhitetipReefSharkEntity.this.getY();
                double z = WhitetipReefSharkEntity.this.getZ();
                WhitetipReefSharkEntity entity = WhitetipReefSharkEntity.this;
                Level world = WhitetipReefSharkEntity.this.level();
                return super.canUse() && IsNightProcedure.execute((LevelAccessor)world);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataActionTime", ((Integer)this.entityData.get(DATA_ActionTime)).intValue());
        compound.putString("DataCurrentAction", (String)this.entityData.get(DATA_CurrentAction));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataActionTime")) {
            this.entityData.set(DATA_ActionTime, (Object)compound.getInt("DataActionTime"));
        }
        if (compound.contains("DataCurrentAction")) {
            this.entityData.set(DATA_CurrentAction, (Object)compound.getString("DataCurrentAction"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(WhitetipReefSharkBiteAnimProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        WhitetipReefSharkOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        WhitetipReefSharkEntity retval = (WhitetipReefSharkEntity)((EntityType)AbyssoulsWildlifeModEntities.WHITETIP_REEF_SHARK.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TROPICAL_FISH)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        WhitetipReefSharkEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        WhitetipReefSharkEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.8);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.5);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.8);
        return builder;
    }
}

