/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity;

import java.util.function.Predicate;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModEntities;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.TunaOnTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class YellowfinTunaEntity
extends Animal {
    public YellowfinTunaEntity(EntityType<YellowfinTunaEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (YellowfinTunaEntity.this.isInWater()) {
                    YellowfinTunaEntity.this.setDeltaMovement(YellowfinTunaEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !YellowfinTunaEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - YellowfinTunaEntity.this.getX();
                    double dy = this.wantedY - YellowfinTunaEntity.this.getY();
                    double dz = this.wantedZ - YellowfinTunaEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * YellowfinTunaEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    YellowfinTunaEntity.this.setYRot(this.rotlerp(YellowfinTunaEntity.this.getYRot(), f, 10.0f));
                    YellowfinTunaEntity.this.yBodyRot = YellowfinTunaEntity.this.getYRot();
                    YellowfinTunaEntity.this.yHeadRot = YellowfinTunaEntity.this.getYRot();
                    if (YellowfinTunaEntity.this.isInWater()) {
                        YellowfinTunaEntity.this.setSpeed((float)YellowfinTunaEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        YellowfinTunaEntity.this.setXRot(this.rotlerp(YellowfinTunaEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(YellowfinTunaEntity.this.getXRot() * ((float)Math.PI / 180)));
                        YellowfinTunaEntity.this.setZza(f3 * f1);
                        YellowfinTunaEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        YellowfinTunaEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    YellowfinTunaEntity.this.setSpeed(0.0f);
                    YellowfinTunaEntity.this.setYya(0.0f);
                    YellowfinTunaEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.3));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.3, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssoulsWildlifeModItems.RAW_SARDINE.get()}), false));
        this.goalSelector.addGoal(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.cod.death"));
    }

    public void baseTick() {
        super.baseTick();
        TunaOnTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        YellowfinTunaEntity retval = (YellowfinTunaEntity)((EntityType)AbyssoulsWildlifeModEntities.YELLOWFIN_TUNA.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.RAW_SARDINE.get())}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        YellowfinTunaEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        YellowfinTunaEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 2.5);
        builder = builder.add(Attributes.MAX_HEALTH, 15.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 2.5);
        return builder;
    }
}

