/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class AdvancedFindWater
extends Goal {
    private final PathfinderMob creature;
    private BlockPos targetPos;

    public AdvancedFindWater(PathfinderMob creature) {
        this.creature = creature;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.creature.onGround() && !this.creature.level().getFluidState(this.creature.blockPosition()).is(FluidTags.WATER)) {
            this.targetPos = this.generateTarget();
            return this.targetPos != null;
        }
        return false;
    }

    public void start() {
        if (this.targetPos != null) {
            this.creature.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 1.0);
        }
    }

    public void tick() {
        if (this.targetPos != null) {
            this.creature.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 1.0);
        }
    }

    public boolean canContinueToUse() {
        return !this.creature.getNavigation().isDone() && this.targetPos != null && !this.creature.level().getFluidState(this.creature.blockPosition()).is(FluidTags.WATER);
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        RandomSource random = this.creature.getRandom();
        int range = 23;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockPos = this.creature.blockPosition().offset(random.nextInt(23) - 11, 3, random.nextInt(23) - 11);
            while (this.creature.level().isEmptyBlock(blockPos) && blockPos.getY() > 1) {
                blockPos = blockPos.below();
            }
            if (!this.creature.level().getFluidState(blockPos).is(FluidTags.WATER)) continue;
            blockpos = blockPos;
        }
        return blockpos;
    }
}

