/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.init;

import net.abyssoul.abyssoulswildlife.potion.AmbusherMobEffect;
import net.abyssoul.abyssoulswildlife.potion.BarnacleParasitismMobEffect;
import net.abyssoul.abyssoulswildlife.potion.BelugasBlessingMobEffect;
import net.abyssoul.abyssoulswildlife.potion.BleedMobEffect;
import net.abyssoul.abyssoulswildlife.potion.CondorsSealMobEffect;
import net.abyssoul.abyssoulswildlife.potion.FinlessPorpoisesSmileMobEffect;
import net.abyssoul.abyssoulswildlife.potion.GoldenTakinDefenceMobEffect;
import net.abyssoul.abyssoulswildlife.potion.GourmetMobEffect;
import net.abyssoul.abyssoulswildlife.potion.InvulnerableMobEffect;
import net.abyssoul.abyssoulswildlife.potion.LongReachMobEffect;
import net.abyssoul.abyssoulswildlife.potion.PoisonOfMambaMobEffect;
import net.abyssoul.abyssoulswildlife.potion.SkyHunterMobEffect;
import net.abyssoul.abyssoulswildlife.potion.SoulFerryingMobEffect;
import net.abyssoul.abyssoulswildlife.potion.TenacityMobEffect;
import net.abyssoul.abyssoulswildlife.procedures.AmbusherEndProcedure;
import net.abyssoul.abyssoulswildlife.procedures.InvulnerableEndProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SkyHunterEndProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class AbyssoulsWildlifeModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"abyssouls_wildlife");
    public static final DeferredHolder<MobEffect, MobEffect> BLEED = REGISTRY.register("bleed", () -> new BleedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> POISON_OF_MAMBA = REGISTRY.register("poison_of_mamba", () -> new PoisonOfMambaMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TENACITY = REGISTRY.register("tenacity", () -> new TenacityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BARNACLE_PARASITISM = REGISTRY.register("barnacle_parasitism", () -> new BarnacleParasitismMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> LONG_REACH = REGISTRY.register("long_reach", () -> new LongReachMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FINLESS_PORPOISES_SMILE = REGISTRY.register("finless_porpoises_smile", () -> new FinlessPorpoisesSmileMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SOUL_FERRYING = REGISTRY.register("soul_ferrying", () -> new SoulFerryingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> AMBUSHER = REGISTRY.register("ambusher", () -> new AmbusherMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BELUGAS_BLESSING = REGISTRY.register("belugas_blessing", () -> new BelugasBlessingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GOURMET = REGISTRY.register("gourmet", () -> new GourmetMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CONDORS_SEAL = REGISTRY.register("condors_seal", () -> new CondorsSealMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SKY_HUNTER = REGISTRY.register("sky_hunter", () -> new SkyHunterMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GOLDEN_TAKIN_DEFENCE = REGISTRY.register("golden_takin_defence", () -> new GoldenTakinDefenceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INVULNERABLE = REGISTRY.register("invulnerable", () -> new InvulnerableMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            AbyssoulsWildlifeModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            AbyssoulsWildlifeModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(AMBUSHER)) {
            AmbusherEndProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(SKY_HUNTER)) {
            SkyHunterEndProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(INVULNERABLE)) {
            InvulnerableEndProcedure.execute(entity);
        }
    }
}

