/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.item;

import java.util.List;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.procedures.BarnacleAxeHitResultProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BarnacleAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 300;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 12;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AbyssoulsWildlifeModItems.BARNACLE.get())});
        }
    };

    public BarnacleAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)7.0f, (float)-3.0f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        BarnacleAxeHitResultProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.barnacle_axe.description_0"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.barnacle_axe.description_1"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.barnacle_axe.description_2"));
    }
}

