/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.item;

import java.util.List;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModParticleTypes;
import net.abyssoul.abyssoulswildlife.procedures.BigtoothSymmetricalSpearUseProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BigtoothSymmetricalSpearItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 3000;
        }

        public float getSpeed() {
            return 14.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 30;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public static ItemAttributeModifiers getNewAttributeModifiers() {
        ResourceLocation BASE_BLOCK_INTERACTION_RANGE_ID = ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"bigtoothspear1");
        ResourceLocation BASE_ENTITY_INTERACTION_RANGE_ID = ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"bigtoothspear2");
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 17.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(BASE_BLOCK_INTERACTION_RANGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_ENTITY_INTERACTION_RANGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public BigtoothSymmetricalSpearItem() {
        super(TOOL_TIER, new Item.Properties().rarity(Rarity.EPIC).attributes(BigtoothSymmetricalSpearItem.getNewAttributeModifiers()));
    }

    public int getEnchantmentValue() {
        return 30;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 128000;
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity ent;
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected && entity instanceof LivingEntity && (ent = (LivingEntity)entity).getTicksUsingItem() == 60 && itemstack.getItem() == ent.getUseItem().getItem()) {
            if (world instanceof Level) {
                Level _level = world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:sizzle")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"abyssouls_wildlife:sizzle")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                ((ServerLevel)world).sendParticles((ParticleOptions)((SimpleParticleType)AbyssoulsWildlifeModParticleTypes.ELECTRIC.get()), entity.getX(), entity.getY() + 1.2, entity.getZ(), 40, 0.0, 0.0, 0.0, 0.3);
                ((ServerLevel)world).sendParticles((ParticleOptions)((SimpleParticleType)AbyssoulsWildlifeModParticleTypes.ELECTRICSTREAM.get()), entity.getX() + entity.getLookAngle().x, entity.getY() + entity.getLookAngle().y + 1.2, entity.getZ() + entity.getLookAngle().z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        BigtoothSymmetricalSpearUseProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.bigtooth_symmetrical_spear.description_0"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.bigtooth_symmetrical_spear.description_1"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.bigtooth_symmetrical_spear.description_2"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.bigtooth_symmetrical_spear.description_3"));
    }
}

