/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.item;

import java.util.List;
import net.abyssoul.abyssoulswildlife.procedures.SharkRadarRightClickAirProcedure;
import net.abyssoul.abyssoulswildlife.procedures.SharkRadarRightClickBlockProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SharkRadarItem
extends Item {
    public SharkRadarItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.shark_radar.description_0"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.shark_radar.description_1"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.shark_radar.description_2"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.shark_radar.description_3"));
        list.add((Component)Component.translatable((String)"item.abyssouls_wildlife.shark_radar.description_4"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        SharkRadarRightClickAirProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        return SharkRadarRightClickBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer(), context.getItemInHand());
    }
}

