/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.mixin;

import net.abyssoul.abyssoulswildlife.configuration.AbyssoulsWildlifeConfigConfiguration;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModItems;
import net.abyssoul.abyssoulswildlife.init.AbyssoulsWildlifeModMobEffects;
import net.abyssoul.abyssoulswildlife.procedures.SeablueBootsFallProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1001)
public abstract class AWLivingEntityMixin {
    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCheckFallDamage(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo ci) {
        LivingEntity player = (LivingEntity)this;
        if (player.fallDistance > 0.0f && player.onGround()) {
            SeablueBootsFallProcedureProcedure.execute((LevelAccessor)player.level(), player.getX(), player.getY(), player.getZ(), (Entity)player);
        }
    }

    @Inject(method={"isBlocking"}, at={@At(value="HEAD")}, cancellable=true)
    private void onParry(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity player = (LivingEntity)this;
        if (player.getUseItem().getItem() == AbyssoulsWildlifeModItems.HIDE_SHIELD.get() || player.getUseItem().getItem() == AbyssoulsWildlifeModItems.FACE_OF_ENDSCOURGE.get()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float Onhurt(float p_32014_, DamageSource damageSource) {
        Entity ent;
        TamableAnimal tam;
        LivingEntity player = (LivingEntity)this;
        Entity entity = damageSource.getEntity();
        if (entity instanceof TamableAnimal && (entity = (tam = (TamableAnimal)entity).getOwner()) instanceof LivingEntity && (ent = entity).getItemBySlot(EquipmentSlot.HEAD).getItem() == AbyssoulsWildlifeModItems.SEABLUE_ARMOR_HELMET.get()) {
            p_32014_ = ent.isInWaterRainOrBubble() ? (float)((double)p_32014_ * 1.6) : (float)((double)p_32014_ * 1.3);
        }
        if (damageSource.getEntity() != null) {
            Vec3 vec3 = new Vec3(damageSource.getEntity().getX() - player.getX(), damageSource.getEntity().getY() - player.getY(), damageSource.getEntity().getZ() - player.getZ());
            if (9.0 < vec3.length() && player.hasEffect(AbyssoulsWildlifeModMobEffects.GOLDEN_TAKIN_DEFENCE)) {
                p_32014_ /= (float)(player.getEffect(AbyssoulsWildlifeModMobEffects.GOLDEN_TAKIN_DEFENCE).getAmplifier() + 2);
            }
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() == AbyssoulsWildlifeModItems.SEABLUE_ARMOR_CHESTPLATE.get()) {
            if (!damageSource.is(DamageTypes.FELL_OUT_OF_WORLD) && p_32014_ > player.getMaxHealth() * 0.3f + player.getHealth() * 0.3f) {
                p_32014_ = player.getMaxHealth() * 0.3f + player.getHealth() * 0.3f;
            }
            float reductionFactor = 0.05f * (float)(player.tickCount - player.getLastHurtByMobTimestamp());
            p_32014_ *= Math.min(Math.abs(reductionFactor), 1.0f);
        }
        return p_32014_;
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        TamableAnimal tam1;
        TamableAnimal tam;
        Entity entity;
        LivingEntity player = (LivingEntity)this;
        if (((Boolean)AbyssoulsWildlifeConfigConfiguration.DISABLE_FRIENDLY_FIRE.get()).booleanValue() && ((entity = source.getEntity()) instanceof TamableAnimal && (tam = (TamableAnimal)entity).isTame() && tam.getOwner() == player || player instanceof TamableAnimal && (tam1 = (TamableAnimal)player).isTame() && tam1.getOwner() == source.getEntity())) {
            cir.setReturnValue((Object)false);
        }
    }
}

