/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.server;

import net.abyssoul.abyssoulswildlife.configuration.AbyssoulsWildlifeConfigConfiguration;
import net.abyssoul.abyssoulswildlife.entity.BossEntity;
import net.abyssoul.abyssoulswildlife.server.BossMusicSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class BossMusicPlayer {
    public static BossMusicSound bossMusic;

    public static void registerEvents() {
        NeoForge.EVENT_BUS.addListener(BossMusicPlayer::onWorldUnload);
    }

    private static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            BossMusicPlayer.resetBossMusic();
        }
    }

    public static void resetBossMusic() {
        if (bossMusic != null) {
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)bossMusic);
            bossMusic = null;
        }
    }

    public static void playBossMusic(BossEntity entity) {
        if (!((Boolean)AbyssoulsWildlifeConfigConfiguration.PLAY_BOSSMUSIC.get()).booleanValue()) {
            return;
        }
        SoundEvent soundEvent = entity.getBossMusic();
        if (soundEvent != null && entity.isAlive()) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (bossMusic != null) {
                float volume = Minecraft.getInstance().options.getSoundSourceVolume(SoundSource.RECORDS);
                if (volume <= 0.0f) {
                    bossMusic = null;
                } else if (bossMusic.getBoss() == entity) {
                    bossMusic.setBoss(null);
                } else if (bossMusic.getBoss() == null && bossMusic.getSoundEvent() == soundEvent) {
                    bossMusic.setBoss(entity);
                }
            } else {
                bossMusic = new BossMusicSound(entity.getBossMusic(), entity);
            }
            if (bossMusic != null && !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)bossMusic)) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)bossMusic);
            }
        }
    }

    public static void stopBossMusic(BossEntity entity) {
        if (!((Boolean)AbyssoulsWildlifeConfigConfiguration.PLAY_BOSSMUSIC.get()).booleanValue()) {
            return;
        }
        if (bossMusic != null && bossMusic.getBoss() == entity) {
            bossMusic.setBoss(null);
        }
    }
}

