/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.server;

import net.abyssoul.abyssoulswildlife.entity.BossEntity;
import net.abyssoul.abyssoulswildlife.server.BossMusicPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class BossMusicSound
extends AbstractTickableSoundInstance {
    private BossEntity boss;
    private int timer;
    private int ticksExisted = 0;
    private int timeUntilFade;
    private final SoundEvent soundEvent;

    public BossMusicSound(SoundEvent sound, BossEntity boss) {
        super(sound, SoundSource.RECORDS, boss.getRandom());
        this.boss = boss;
        this.soundEvent = sound;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.looping = true;
        this.delay = 0;
        this.x = boss.getX();
        this.y = boss.getY();
        this.z = boss.getZ();
        this.timer = 40;
        this.timeUntilFade = 80;
    }

    public boolean canPlaySound() {
        return BossMusicPlayer.bossMusic == this;
    }

    public void tick() {
        if (this.boss == null || !this.boss.isAlive() || this.boss.isSilent()) {
            if (this.boss != null && !this.boss.isAlive()) {
                this.timeUntilFade = 0;
            }
            this.boss = null;
            if (this.timeUntilFade > 0) {
                --this.timeUntilFade;
            } else {
                this.timer = Math.max(this.timer - 1, 0);
            }
        } else {
            this.timer = Math.min(this.timer + 1, 40);
            this.timeUntilFade = 20;
        }
        if (this.timer < 1) {
            this.stop();
            BossMusicPlayer.bossMusic = null;
        }
        this.volume = (float)this.timer / 40.0f;
        if (this.ticksExisted % 100 == 0) {
            Minecraft.getInstance().getMusicManager().stopPlaying();
        }
        ++this.ticksExisted;
    }

    public void setBoss(BossEntity boss) {
        this.boss = boss;
    }

    public BossEntity getBoss() {
        return this.boss;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }
}

