/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.server;

import net.abyssoul.abyssoulswildlife.server.MessageBossBar;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class CustomServerBossEvent
extends ServerBossEvent {
    private int renderType;

    public CustomServerBossEvent(Component component, BossEvent.BossBarColor bossBarColor, boolean dark, int renderType) {
        super(component, bossBarColor, BossEvent.BossBarOverlay.PROGRESS);
        this.setDarkenScreen(dark);
        this.renderType = renderType;
    }

    public void setRenderType(int renderType) {
        if (renderType != this.renderType) {
            this.renderType = renderType;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MessageBossBar.Display(this.getId(), renderType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void addPlayer(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MessageBossBar.Display(this.getId(), this.renderType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.addPlayer(serverPlayer);
    }

    public void removePlayer(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MessageBossBar.Remove(this.getId(), this.renderType), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.removePlayer(serverPlayer);
    }
}

