/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.server;

import java.util.UUID;
import net.abyssoul.abyssoulswildlife.client.ClientEvents;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class MessageBossBar
implements CustomPacketPayload {
    protected final UUID bossEvent;
    protected final int rendertype;

    public MessageBossBar(UUID bossEvent, int rendertype) {
        this.bossEvent = bossEvent;
        this.rendertype = rendertype;
    }

    public UUID getBossEvent() {
        return this.bossEvent;
    }

    public int getRendertype() {
        return this.rendertype;
    }

    public static class Remove
    extends MessageBossBar {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"remove_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, MessageBossBar::getBossEvent, (StreamCodec)ByteBufCodecs.INT, MessageBossBar::getRendertype, Remove::new);

        public Remove(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            ClientEvents.bossBarRenderTypes.remove(payload.bossEvent);
        }
    }

    public static class Display
    extends MessageBossBar {
        public static final CustomPacketPayload.Type<Display> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"add_custom_bossbar"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, MessageBossBar::getBossEvent, (StreamCodec)ByteBufCodecs.INT, MessageBossBar::getRendertype, Display::new);

        public Display(UUID bossEvent, int rendertype) {
            super(bossEvent, rendertype);
        }

        public CustomPacketPayload.Type<Display> type() {
            return TYPE;
        }

        public static void execute(Display payload, IPayloadContext context) {
            ClientEvents.bossBarRenderTypes.put(payload.bossEvent, payload.rendertype);
        }
    }
}

