/*
 * Decompiled with CFR 0.152.
 */
package net.abyssoul.abyssoulswildlife.server;

import net.abyssoul.abyssoulswildlife.entity.BossEntity;
import net.abyssoul.abyssoulswildlife.server.BossMusicPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageMusic(int entityID, boolean play) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageMusic> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"abyssouls_wildlife", (String)"music"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageMusic> STREAM_CODEC = CustomPacketPayload.codec(MessageMusic::write, MessageMusic::new);

    public MessageMusic(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeBoolean(this.play());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final MessageMusic message, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = ctx.player().level().getEntity(message.entityID);
                    if (entity instanceof BossEntity) {
                        BossEntity am = (BossEntity)entity;
                        if (message.play) {
                            BossMusicPlayer.playBossMusic(am);
                        } else {
                            BossMusicPlayer.stopBossMusic(am);
                        }
                    }
                }
            });
        }
    }
}

