/*
 * Decompiled with CFR 0.152.
 */
package net.orbit.block.entity.renderer;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1511;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.orbit.block.entity.custom.PedestalBlockEntity;
import net.orbit.block.entity.custom.PedestalRenderConfig;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class PedestalBlockEntityRenderer
implements class_827<PedestalBlockEntity> {
    private final class_898 entityRenderDispatcher;
    private PedestalRenderConfig renderConfig;

    public PedestalBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.entityRenderDispatcher = ctx.method_43334();
        this.renderConfig = PedestalRenderConfig.defaultMultiItem();
    }

    public void setRenderConfig(PedestalRenderConfig config) {
        this.renderConfig = config;
    }

    private int getLightLevel(class_1937 world, class_2338 pos) {
        int bLight = world.method_8314(class_1944.field_9282, pos);
        int sLight = world.method_8314(class_1944.field_9284, pos);
        return class_765.method_23687((int)bLight, (int)sLight);
    }

    private void renderEndCrystalEntity(PedestalBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        float scale = this.renderConfig.crystalScale();
        matrices.method_22905(scale, scale, scale);
        class_1511 crystal = (class_1511)class_1299.field_6110.method_5883(entity.method_10997(), class_3730.field_16462);
        if (crystal != null && entity.method_10997() != null) {
            crystal.method_6839(this.renderConfig.crystalShowBottom());
            crystal.field_6012 = (int)entity.getRenderingRotation();
            crystal.field_28627 = 0.0f;
        }
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(0.0f));
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(0.0f));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(0.0f));
        this.entityRenderDispatcher.method_62424((class_1297)crystal, 0.0, 0.0, 0.0, 0.0f, matrices, vertexConsumers, light);
    }

    private void renderSingleItem(class_1799 item, PedestalBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        matrices.method_22903();
        class_243 offset = this.renderConfig.itemOffset();
        matrices.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        float levitation = (float)Math.sin(entity.getRenderingRotation() * this.renderConfig.levitationSpeed()) * this.renderConfig.levitationAmplitude();
        matrices.method_46416(0.0f, levitation, 0.0f);
        class_243 rotation = this.renderConfig.itemRotation().method_1019(this.renderConfig.rotationStep().method_1021((double)entity.getRenderingRotation()));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees((float)rotation.field_1352));
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees((float)rotation.field_1351));
        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees((float)rotation.field_1350));
        float scale = this.renderConfig.itemScale();
        matrices.method_22905(-scale, scale, -scale);
        if (item.method_31574(class_1802.field_8301)) {
            this.renderEndCrystalEntity(entity, matrices, vertexConsumers, light);
        } else {
            itemRenderer.method_23178(item, class_811.field_4317, light, class_4608.field_21444, matrices, vertexConsumers, entity.method_10997(), 1);
        }
        matrices.method_22909();
    }

    private void renderMultiItems(class_2371<class_1799> items, PedestalBlockEntity entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        float radius = this.renderConfig.radius();
        for (int i = 0; i < items.size(); ++i) {
            matrices.method_22903();
            float angle = (float)(Math.PI * 2 * (double)i / (double)items.size()) + entity.getRenderingRotation();
            float x = (float)Math.cos(angle) * radius;
            float z = (float)Math.sin(angle) * radius;
            class_243 offset = this.renderConfig.itemOffset();
            float delta = this.renderConfig.multiItemLevitationAmplitude();
            float fx = (float)((double)x * Math.cos(angle) + (double)z * Math.sin(angle));
            float fz = (float)((double)z * Math.cos(angle) - (double)x * Math.sin(angle));
            matrices.method_22904(offset.field_1352 + (double)x, offset.field_1351 + (double)(fx * fz * delta), offset.field_1350 + (double)z);
            float levitation = (float)Math.sin(angle * this.renderConfig.levitationSpeed()) * this.renderConfig.levitationAmplitude();
            matrices.method_46416(0.0f, levitation, 0.0f);
            if (((class_1799)items.get(i)).method_31574(class_1802.field_8301)) {
                this.renderEndCrystalEntity(entity, matrices, vertexConsumers, light);
            } else {
                float scale = this.renderConfig.itemScale();
                matrices.method_22905(-scale, scale, -scale);
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(entity.getRenderingRotation() + (float)i * 360.0f / (float)items.size()));
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(45.0f * x * z));
                if (entity.method_10997() != null) {
                    itemRenderer.method_23178((class_1799)items.get(i), class_811.field_4317, this.getLightLevel(entity.method_10997(), entity.method_11016()), class_4608.field_21444, matrices, vertexConsumers, entity.method_10997(), 1);
                }
            }
            matrices.method_22909();
        }
    }

    public void render(PedestalBlockEntity entity, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos) {
        this.setRenderConfig(entity.getRenderConfig());
        class_2371<class_1799> items = entity.getNonNullItems();
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            this.renderSingleItem((class_1799)items.getFirst(), entity, matrices, vertexConsumers, light);
        } else {
            this.renderMultiItems(items, entity, matrices, vertexConsumers, light);
        }
        entity.updateRotation(this.renderConfig.rotationSpeed());
    }
}

