/*
 * Decompiled with CFR 0.152.
 */
package net.orbit.screen.widget;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7842;

@Environment(value=EnvType.CLIENT)
public class NumericInputWidget
extends class_339 {
    private final class_7842 labelWidget;
    private final class_342 textField;
    private final class_4185 incrementButton;
    private final class_4185 decrementButton;
    private float value;
    private final float minValue;
    private final float maxValue;
    private final float step;
    private final Consumer<Float> onChange;

    public NumericInputWidget(int x, int y, int width, int height, class_2561 label, float initialValue, float minValue, float maxValue, float step, Consumer<Float> onChange) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.value = initialValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.onChange = onChange;
        int labelWidth = 70;
        int buttonWidth = 18;
        int fieldWidth = width - labelWidth - buttonWidth * 2 - 4;
        this.labelWidget = new class_7842(x, y, labelWidth, height, label, class_310.method_1551().field_1772);
        this.labelWidget.method_48596();
        this.labelWidget.method_46438(0xFFFFFF);
        this.textField = new class_342(class_310.method_1551().field_1772, x + labelWidth + 2, y, fieldWidth, height, (class_2561)class_2561.method_43473());
        this.textField.method_1880(10);
        this.textField.method_1852(String.format("%.2f", Float.valueOf(this.value)));
        this.textField.method_1863(this::onTextChanged);
        this.textField.method_1888(true);
        this.decrementButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> this.adjustValue(-step)).method_46434(x + labelWidth + fieldWidth + 2, y, buttonWidth, height).method_46431();
        this.incrementButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> this.adjustValue(step)).method_46434(x + labelWidth + fieldWidth + buttonWidth + 4, y, buttonWidth, height).method_46431();
    }

    private void adjustValue(float delta) {
        this.value = Math.max(this.minValue, Math.min(this.maxValue, this.value + delta));
        this.textField.method_1852(String.format("%.2f", Float.valueOf(this.value)));
        this.onChange.accept(Float.valueOf(this.value));
    }

    private void onTextChanged(String text) {
        try {
            float newValue = Float.parseFloat(text.replace(',', '.'));
            if (newValue >= this.minValue && newValue <= this.maxValue) {
                this.value = newValue;
                this.onChange.accept(Float.valueOf(this.value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        this.labelWidget.method_25394(context, mouseX, mouseY, deltaTicks);
        this.textField.method_25394(context, mouseX, mouseY, deltaTicks);
        this.decrementButton.method_25394(context, mouseX, mouseY, deltaTicks);
        this.incrementButton.method_25394(context, mouseX, mouseY, deltaTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean textFieldClicked = this.textField.method_25402(mouseX, mouseY, button);
        boolean decrementClicked = this.decrementButton.method_25402(mouseX, mouseY, button);
        boolean incrementClicked = this.incrementButton.method_25402(mouseX, mouseY, button);
        if (textFieldClicked) {
            this.textField.method_25365(true);
        }
        return textFieldClicked || decrementClicked || incrementClicked;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.textField.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.textField.method_25400(chr, modifiers);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        this.textField.method_25365(focused);
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.labelWidget.method_25369());
    }
}

