/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity;

import aqario.fowlplay.client.render.entity.layer.BirdHeldItemLayer;
import aqario.fowlplay.client.render.entity.layer.PigeonBundleLayer;
import aqario.fowlplay.client.render.entity.model.PigeonModel;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class PigeonRenderer
extends MobRenderer<PigeonEntity, PigeonModel> {
    private static final ResourceLocation MARTHA_TEXTURE = FowlPlay.id("textures/entity/pigeon/martha.png");

    public PigeonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PigeonModel(context.bakeLayer(PigeonModel.MODEL_LAYER)), 0.2f);
        this.addLayer(new BirdHeldItemLayer(this, context.getItemInHandRenderer(), new Vec3(0.0, -0.0225, -0.1475)));
        this.addLayer(new PigeonBundleLayer((RenderLayerParent<PigeonEntity, PigeonModel>)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(PigeonEntity pigeon) {
        String string = ChatFormatting.stripFormatting((String)pigeon.getName().getString());
        if ("Martha".equals(string)) {
            return MARTHA_TEXTURE;
        }
        return ((PigeonVariant)pigeon.getVariant().value()).texture();
    }
}

