/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.BlueJayAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.BlueJayEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BlueJayModel
extends FlyingBirdModel<BlueJayEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("blue_jay"), "main");
    public final ModelPart crest;

    public BlueJayModel(ModelPart root) {
        super(root);
        this.crest = this.head.getChild("crest");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)1.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-1.75f, (float)-2.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        head.addOrReplaceChild("crest", CubeListBuilder.create().texOffs(8, 6).addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.2f, (float)0.4363f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(16, 3).addBox(-0.5f, -3.0f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 0).addBox(-0.75f, -1.0f, -0.5f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-2.5f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-0.25f, -1.0f, -0.5f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.75f, (float)-2.5f, (float)-1.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(8, 9).addBox(-0.5f, 0.0f, -1.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.25f, (float)-1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(3, 15).addBox(0.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)0.0f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(8, 9).mirror().addBox(-4.5f, 0.0f, -1.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-3.25f, (float)-1.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(3, 15).mirror().addBox(-5.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)0.0f, (float)-1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -1.0f, 1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-1.0f, -1.0f, 3.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(1, 3).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-1, 2).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(1, 3).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(-1, 2).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void prepareMobModel(BlueJayEntity blueJay, float limbAngle, float limbDistance, float tickDelta) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        super.prepareMobModel((Entity)blueJay, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)blueJay.tickCount + tickDelta;
        float bodyYaw = Mth.rotLerp((float)tickDelta, (float)blueJay.yBodyRotO, (float)blueJay.yBodyRot);
        float headYaw = Mth.rotLerp((float)tickDelta, (float)blueJay.yHeadRotO, (float)blueJay.yHeadRot);
        float relativeHeadYaw = Mth.wrapDegrees((float)(headYaw - bodyYaw));
        float headPitch = Mth.lerp((float)tickDelta, (float)blueJay.xRotO, (float)blueJay.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)blueJay)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!blueJay.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (blueJay.isFlying()) {
            this.root.xRot = blueJay.getViewXRot(tickDelta) * ((float)Math.PI / 180);
            this.root.zRot = blueJay.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (blueJay.isFlying()) {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        } else {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        }
        if (!blueJay.isFlying() && !blueJay.isInWaterOrBubble()) {
            this.animateWalk(BlueJayAnimations.WALKING, limbAngle, limbDistance, 6.0f, 6.0f);
        }
        this.animate(blueJay.standingState, BlueJayAnimations.STANDING, ageInTicks);
        this.animate(blueJay.swimmingState, BlueJayAnimations.SWIMMING, ageInTicks);
        this.animate(blueJay.glidingState, BlueJayAnimations.GLIDING, ageInTicks);
        this.animate(blueJay.flappingState, BlueJayAnimations.FLAPPING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

