/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.CrowAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CrowModel
extends FlyingBirdModel<CrowEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("crow"), "main");

    public CrowModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)1.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-2.75f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -4.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.75f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(10, 7).addBox(-1.5f, -1.0f, -0.5f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-3.25f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(10, 7).mirror().addBox(-0.5f, -1.0f, -0.5f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-3.25f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(0, 19).addBox(-0.5f, 0.0f, -1.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.75f, (float)-1.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(-6, 26).addBox(0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)0.0f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-5.5f, 0.0f, -1.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-3.75f, (float)-1.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(-6, 26).mirror().addBox(-6.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.5f, (float)0.0f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, -1.0f, 1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(-1.0f, -1.001f, 3.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.75f, (float)0.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)2.25f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)2.25f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(2, 3).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-1, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(2, 3).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-1, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void prepareMobModel(CrowEntity crow, float limbAngle, float limbDistance, float tickDelta) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        super.prepareMobModel((Entity)crow, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)crow.tickCount + tickDelta;
        float bodyYaw = Mth.rotLerp((float)tickDelta, (float)crow.yBodyRotO, (float)crow.yBodyRot);
        float headYaw = Mth.rotLerp((float)tickDelta, (float)crow.yHeadRotO, (float)crow.yHeadRot);
        float relativeHeadYaw = Mth.wrapDegrees((float)(headYaw - bodyYaw));
        float headPitch = Mth.lerp((float)tickDelta, (float)crow.xRotO, (float)crow.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)crow)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!crow.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (crow.isFlying()) {
            this.root.xRot = crow.getViewXRot(tickDelta) * ((float)Math.PI / 180);
            this.root.zRot = crow.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (crow.isFlying() || crow.isInWaterOrBubble()) {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        } else {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        }
        if (!crow.isFlying() && !crow.isInWaterOrBubble()) {
            this.animateWalk(CrowAnimations.WALKING, limbAngle, limbDistance, 5.0f, 5.0f);
        }
        this.animate(crow.standingState, CrowAnimations.STANDING, ageInTicks);
        this.animate(crow.swimmingState, CrowAnimations.SWIMMING, ageInTicks);
        this.animate(crow.glidingState, CrowAnimations.GLIDING, ageInTicks);
        this.animate(crow.flappingState, CrowAnimations.FLAPPING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

