/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.HawkAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HawkModel
extends FlyingBirdModel<HawkEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("hawk"), "main");

    public HawkModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)1.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.75f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-0.5f, -0.25f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)).texOffs(0, 6).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.25f, (float)-1.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 1).addBox(-2.0f, -2.9021f, -6.3154f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(16, 12).addBox(-2.0f, -2.9021f, 0.6846f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.9021f, (float)2.3154f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, -3.0f, -3.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4021f, (float)-2.3154f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -1.0f, -0.75f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-4.0f, (float)-0.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-1.0f, -1.0f, -0.75f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.75f, (float)-4.0f, (float)-0.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, 0.0f, -1.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.5f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(19, 10).addBox(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)-1.5f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-8.0f, 0.0f, -1.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-4.5f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(19, 10).mirror().addBox(-10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-8.0f, (float)0.0f, (float)-1.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(15, 0).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(49, 0).addBox(-1.5f, -0.5f, 3.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(19, 0).addBox(-1.0f, -0.503f, 1.5f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)3.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, 0.999f, -1.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        tail.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(19, 0).addBox(-1.0f, 0.998f, -1.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(19, 0).mirror().addBox(-1.0f, 0.998f, -1.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-1.0f, 0.999f, -1.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(21, 4).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)).texOffs(15, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(15, 4).mirror().addBox(-1.0f, 4.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)1.0f, (float)2.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(21, 4).mirror().addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)).mirror(false).texOffs(15, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(15, 4).addBox(-1.0f, 4.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void prepareMobModel(HawkEntity hawk, float limbAngle, float limbDistance, float tickDelta) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        super.prepareMobModel((Entity)hawk, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)hawk.tickCount + tickDelta;
        float bodyYaw = Mth.rotLerp((float)tickDelta, (float)hawk.yBodyRotO, (float)hawk.yBodyRot);
        float headYaw = Mth.rotLerp((float)tickDelta, (float)hawk.yHeadRotO, (float)hawk.yHeadRot);
        float relativeHeadYaw = Mth.wrapDegrees((float)(headYaw - bodyYaw));
        float headPitch = Mth.lerp((float)tickDelta, (float)hawk.xRotO, (float)hawk.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)hawk)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!hawk.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (hawk.isFlying()) {
            this.root.xRot = hawk.getViewXRot(tickDelta) * ((float)Math.PI / 180);
            this.root.zRot = hawk.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (hawk.isFlying() || hawk.isInWaterOrBubble()) {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        } else {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        }
        if (hawk.isFlying()) {
            this.animateWalk(HawkAnimations.FLAPPING, limbAngle, limbDistance, 1.5f, 1.5f);
        } else if (!hawk.isInWaterOrBubble()) {
            this.animateWalk(HawkAnimations.WALKING, limbAngle, limbDistance, 2.5f, 4.0f);
        }
        this.animate(hawk.standingState, HawkAnimations.STANDING, ageInTicks);
        this.animate(hawk.swimmingState, HawkAnimations.SWIMMING, ageInTicks);
        this.animate(hawk.glidingState, HawkAnimations.GLIDING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

