/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class BlueJayEntity
extends FlyingBirdEntity
implements BirdBrain<BlueJayEntity> {
    public BlueJayEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.BLUE_JAY_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.BLUE_JAY_AVOIDS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    @Override
    protected void updateAnimations() {
        this.standingState.animateWhen(!this.isFlying() && !this.isInWaterOrBubble(), this.tickCount);
        this.flappingState.animateWhen(this.isFlying(), this.tickCount);
        this.swimmingState.animateWhen(!this.isFlying() && this.isInWaterOrBubble(), this.tickCount);
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_BLUE_JAY_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().blueJayCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 480;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_BLUE_JAY_HURT.get();
    }

    protected Brain.Provider<BlueJayEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends BlueJayEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor()});
    }

    public BrainActivityGroup<? extends BlueJayEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid(), FlightBehaviours.stopFalling(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        super.customServerAiStep();
    }
}

