/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.core.FowlPlay;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.platform.PlatformHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record GooseVariant(ResourceLocation texture, ModelType modelType) {
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<GooseVariant>> PACKET_CODEC = ByteBufCodecs.holderRegistry(FowlPlayRegistries.GOOSE_VARIANT);
    public static final ResourceKey<GooseVariant> GREYLAG = GooseVariant.register("greylag", ModelType.WILD);
    public static final ResourceKey<GooseVariant> CANADA = GooseVariant.register("canada", ModelType.WILD);
    public static final ResourceKey<GooseVariant> SWAN = GooseVariant.register("swan", ModelType.WILD);
    public static final ResourceKey<GooseVariant> EMDEN = GooseVariant.register("emden", ModelType.DOMESTIC);
    public static final ResourceKey<GooseVariant> CHINESE = GooseVariant.register("chinese", ModelType.DOMESTIC);

    private static ResourceKey<GooseVariant> register(String id, ModelType modelType) {
        ResourceKey key = ResourceKey.create(FowlPlayRegistries.GOOSE_VARIANT, (ResourceLocation)FowlPlay.id(id));
        ResourceLocation texture = FowlPlay.id("textures/entity/goose/" + key.location().getPath() + "_goose.png");
        PlatformHelper.registerVariant(id, key, () -> new GooseVariant(texture, modelType));
        return key;
    }

    public static void init() {
    }

    public static enum ModelType implements StringRepresentable
    {
        WILD("wild"),
        DOMESTIC("modelType");

        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

