/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetAdultWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomFlightTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class RavenEntity
extends TrustingBirdEntity
implements BirdBrain<RavenEntity> {
    public RavenEntity(EntityType<? extends RavenEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createRavenAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.225f).add(Attributes.FLYING_SPEED, (double)0.24f);
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)24, (Object)32);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
    }

    public boolean isBaby() {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.RAVEN_FOOD);
    }

    @Override
    public boolean canHunt(LivingEntity target) {
        return target.getType().is(FowlPlayEntityTypeTags.RAVEN_HUNT_TARGETS) || target.getType().is(FowlPlayEntityTypeTags.RAVEN_BABY_HUNT_TARGETS) && target.isBaby();
    }

    @Override
    public boolean shouldAttack(LivingEntity target) {
        if (this.hasLowHealth()) {
            return false;
        }
        LivingEntity hurtBy = BrainUtils.getLastAttacker((LivingEntity)this);
        if (!(target.getType().is(FowlPlayEntityTypeTags.RAVEN_ATTACK_TARGETS) || hurtBy != null && hurtBy.equals((Object)target))) {
            return false;
        }
        Optional<List> nearbyAdults = Optional.ofNullable((List)BrainUtils.getMemory((LivingEntity)this, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get()));
        return nearbyAdults.filter(passiveEntities -> passiveEntities.size() >= 2).isPresent();
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.RAVEN_AVOIDS);
    }

    @Override
    public void updateAnimations() {
        this.standingState.animateWhen(!this.isFlying() && !this.isInWaterOrBubble(), this.tickCount);
        this.glidingState.animateWhen(this.isFlying(), this.tickCount);
        this.swimmingState.animateWhen(!this.isFlying() && this.isInWaterOrBubble(), this.tickCount);
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    @Override
    public float getWaterline() {
        return 0.5f;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_RAVEN_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().ravenCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 1200;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_RAVEN_HURT.get();
    }

    protected Brain.Provider<RavenEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends RavenEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends RavenEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightBehaviours.stopFalling(), new SetAttackTarget(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends RavenEntity> getFightTasks() {
        return BirdBrain.fightActivity(new Behavior[]{new InvalidateAttackTarget(), FlightBehaviours.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0)});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Override
    public BrainActivityGroup<? extends RavenEntity> getSoarTasks() {
        return BirdBrain.soarActivity(new Behavior[]{new OneRandomBehaviour(new Pair[]{Pair.of(new SetRandomFlightTarget(), (Object)5), Pair.of(SetAdultWalkTarget.create(Birds.STAY_NEAR_ENTITY_RANGE), (Object)2)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET))});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void customServerAiStep() {
        Brain brain = this.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        this.tickBrain((LivingEntity)this);
        if (activity == Activity.FIGHT && brain.getActiveNonCoreActivity().orElse(null) != Activity.FIGHT) {
            brain.setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 2400L);
        }
        super.customServerAiStep();
    }
}

