/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.AnimationStateList;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class SparrowEntity
extends FlyingBirdEntity
implements BirdBrain<SparrowEntity>,
Flocking {
    public final AnimationState scratchingState = new AnimationState();
    public final AnimationState preeningState = new AnimationState();
    private static final int FLAP_FREQUENCY = 1;
    private static final int FLAP_DURATION = 8;
    private int timeSinceLastFlap = 1;
    private int flapTime = 0;

    public SparrowEntity(EntityType<? extends SparrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean isBaby() {
        return false;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.SPARROW_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.SPARROW_AVOIDS);
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    protected AnimationStateList createIdleAnimations() {
        return new AnimationStateList().with(this.scratchingState, 1).with(this.preeningState, 3);
    }

    @Override
    protected void updateAnimations() {
        if (!this.isFlying() && !this.isInWaterOrBubble()) {
            if (this.random.nextInt(1000) < this.idleAnimationChance++ && !this.isMoving()) {
                this.resetIdleAnimationDelay();
                this.standingState.stop();
                this.preeningState.stop();
                this.scratchingState.stop();
                if (this.getRandom().nextFloat() < 0.75f) {
                    this.preeningState.start(this.tickCount);
                } else {
                    this.scratchingState.start(this.tickCount);
                }
            } else if (this.isMoving()) {
                this.preeningState.stop();
                this.scratchingState.stop();
            }
            if (!this.preeningState.isStarted() && !this.scratchingState.isStarted()) {
                this.standingState.startIfStopped(this.tickCount);
            } else {
                this.standingState.stop();
            }
        } else {
            this.standingState.stop();
            this.preeningState.stop();
            this.scratchingState.stop();
        }
        if (this.isFlying()) {
            if (this.timeSinceLastFlap >= 1) {
                this.timeSinceLastFlap = 0;
                ++this.flapTime;
            } else if (this.isAnimatingFlapping()) {
                ++this.flapTime;
                this.glidingState.stop();
                this.flappingState.startIfStopped(this.tickCount);
            } else {
                ++this.timeSinceLastFlap;
                this.flapTime = 0;
                this.flappingState.stop();
                this.glidingState.startIfStopped(this.tickCount);
            }
        } else {
            this.timeSinceLastFlap = 1;
            this.flapTime = 0;
            this.flappingState.stop();
            this.glidingState.stop();
        }
        this.swimmingState.animateWhen(!this.isFlying() && this.isInWaterOrBubble(), this.tickCount);
    }

    private boolean isAnimatingFlapping() {
        return this.flapTime >= 0 && this.flapTime < 8;
    }

    @Override
    protected boolean isFlapping() {
        return this.isFlying() && this.isAnimatingFlapping();
    }

    @Override
    protected int getIdleAnimationDelay() {
        return 400;
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_SPARROW_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_SPARROW_SONG.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().sparrowCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().sparrowSongVolume;
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    public int getSongDelay() {
        return 360;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_SPARROW_HURT.get();
    }

    protected Brain.Provider<SparrowEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends SparrowEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor()});
    }

    public BrainActivityGroup<? extends SparrowEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid(), FlightBehaviours.stopFalling(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{new LeaderlessFlocking(3, 0.03f, 0.6f, 0.05f, 3.0f), CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends SparrowEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        super.customServerAiStep();
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }
}

