/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.core.FowlPlayEntityDataSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class TrustingBirdEntity
extends FlyingBirdEntity {
    protected static final EntityDataAccessor<List<UUID>> TRUSTED = SynchedEntityData.defineId(TrustingBirdEntity.class, FowlPlayEntityDataSerializers.UUID_LIST);

    protected TrustingBirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public int getFleeRange(LivingEntity target) {
        return !this.getTrustedUuids().isEmpty() && target instanceof Player ? 8 : super.getFleeRange(target);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TRUSTED, new ArrayList());
    }

    protected ListTag toNbtList(List<UUID> uuids) {
        ListTag nbtList = new ListTag();
        for (UUID uuid : uuids) {
            nbtList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        return nbtList;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("trusted", (Tag)this.toNbtList(this.getTrustedUuids()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        ListTag list;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("trusted") && (list = (ListTag)nbt.get("trusted")) != null) {
            list.forEach(element -> this.addTrustedUuid(NbtUtils.loadUUID((Tag)element)));
        }
    }

    @Override
    protected void pickUpItem(ItemEntity item) {
        UUID thrower;
        super.pickUpItem(item);
        UUID uUID = thrower = item.getOwner() != null ? item.getOwner().getUUID() : null;
        if (thrower != null && !this.trustsUuid(thrower) && this.random.nextInt(3) == 0) {
            this.addTrustedUuid(thrower);
            this.level().broadcastEntityEvent((Entity)this, (byte)14);
        }
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 14) {
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 20;
            }
        } else {
            super.handleEntityEvent(status);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAmbient() && !this.getTrustedUuids().isEmpty()) {
            this.setAmbient(false);
        }
    }

    public List<UUID> getTrustedUuids() {
        return (List)this.entityData.get(TRUSTED);
    }

    public void addTrustedUuid(UUID uuid) {
        List trusted = (List)this.entityData.get(TRUSTED);
        trusted.add(uuid);
        this.entityData.set(TRUSTED, (Object)trusted);
    }

    public void removeTrustedUuid(UUID uuid) {
        List trusted = (List)this.entityData.get(TRUSTED);
        trusted.remove(uuid);
        this.entityData.set(TRUSTED, (Object)trusted);
    }

    public void stopTrusting(Player player) {
        this.removeTrustedUuid(player.getUUID());
    }

    public List<Player> getTrusted() {
        List<UUID> uuids = this.getTrustedUuids();
        ArrayList<Player> entities = new ArrayList<Player>();
        for (UUID uuid : uuids) {
            entities.add(this.level().getPlayerByUUID(uuid));
        }
        return entities;
    }

    @Override
    public boolean canAttack(LivingEntity target) {
        Player player;
        return (!(target instanceof Player) || !this.trusts(player = (Player)target)) && super.canAttack(target);
    }

    public boolean trusts(Player player) {
        return this.getTrusted().contains(player);
    }

    public boolean trustsUuid(UUID uuid) {
        return this.getTrustedUuids().contains(uuid);
    }
}

