/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class GuidedFlocking
extends ExtendedBehaviour<FlyingBirdEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(3).present((MemoryModuleType<?>)FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get()).absent(FowlPlayMemoryTypes.IS_AVOIDING.get(), FowlPlayMemoryTypes.SEES_FOOD.get());
    private static final int VIEW_RADIUS = 8;
    public float coherence;
    public float alignment;
    public final float separation;
    public final float separationRange;
    private FlyingBirdEntity leader;
    private List<? extends AgeableMob> nearbyBirds;

    public GuidedFlocking(float separation, float separationRange) {
        this.separation = separation;
        this.separationRange = separationRange;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, FlyingBirdEntity bird) {
        if (!bird.isFlying()) {
            return false;
        }
        Brain brain = bird.getBrain();
        if (!BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get())) {
            return false;
        }
        this.nearbyBirds = (List)BrainUtils.getMemory((Brain)brain, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get());
        assert (this.nearbyBirds != null);
        this.nearbyBirds.removeIf(entity -> entity.distanceToSqr((Entity)bird) > 64.0);
        if (this.nearbyBirds.isEmpty()) {
            return false;
        }
        this.leader = null;
        this.nearbyBirds.forEach(entity -> {
            Flocking flockingBird;
            if (entity instanceof Flocking && (flockingBird = (Flocking)entity).isLeader()) {
                this.leader = (FlyingBirdEntity)((Object)((Object)flockingBird));
            }
        });
        if (this.leader == null) {
            ((Flocking)((Object)bird)).setLeader();
            return false;
        }
        return true;
    }

    protected boolean canStillUse(ServerLevel world, FlyingBirdEntity bird, long time) {
        return this.checkExtraStartConditions(world, bird);
    }

    protected void tick(FlyingBirdEntity bird) {
        Vec3 heading = this.getHeading(bird).add(bird.position());
        bird.getMoveControl().setWantedPosition(heading.x, heading.y, heading.z, (double)(bird.getRandom().nextFloat() - bird.getRandom().nextFloat()) * 1.5 + 2.0);
    }

    private Vec3 getHeading(FlyingBirdEntity bird) {
        Vec3 separation = Vec3.ZERO;
        Vec3 alignment = Vec3.ZERO;
        Vec3 cohesion = Vec3.ZERO;
        for (AgeableMob ageableMob : this.nearbyBirds) {
            if (ageableMob.position().subtract(bird.position()).length() < (double)this.separationRange) {
                separation = separation.subtract(ageableMob.position().subtract(bird.position()));
            }
            alignment = alignment.add(ageableMob.getDeltaMovement());
            cohesion = cohesion.add(ageableMob.position());
        }
        alignment = alignment.scale((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.scale((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.subtract(bird.position());
        cohesion = cohesion.scale((double)this.coherence);
        alignment = alignment.scale((double)this.alignment);
        separation = separation.scale((double)this.separation);
        Vec3 randomness = new Vec3((double)(bird.getRandom().nextFloat() - bird.getRandom().nextFloat()), (double)(bird.getRandom().nextFloat() - bird.getRandom().nextFloat()), (double)(bird.getRandom().nextFloat() - bird.getRandom().nextFloat())).scale(0.5);
        return cohesion.add(separation).add(alignment).add(randomness);
    }
}

