/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.FreePositionTracker;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetRandomLookTarget<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).absent(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET);
    protected FloatProvider runChance = ConstantFloat.of((float)1.0f);
    private long timeUntilNextLook = 0L;

    public SetRandomLookTarget() {
        this.runtimeProvider = entity -> entity.getRandom().nextIntBetweenInclusive(20, 60);
    }

    public SetRandomLookTarget<E> lookChance(float chance) {
        return this.lookChance((FloatProvider)ConstantFloat.of((float)chance));
    }

    public SetRandomLookTarget<E> lookChance(FloatProvider chance) {
        this.runChance = chance;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return entity.getRandom().nextFloat() < this.runChance.sample(entity.getRandom());
    }

    protected boolean shouldKeepRunning(E entity) {
        return !BrainUtils.hasMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
    }

    protected void tick(E entity) {
        if (this.timeUntilNextLook <= entity.level().getGameTime()) {
            this.lookAround(entity);
        }
    }

    private void lookAround(E entity) {
        double angle = 6.2831854820251465 * entity.getRandom().nextDouble();
        int lookTime = entity.getRandom().nextIntBetweenInclusive(15, 60);
        this.timeUntilNextLook = entity.level().getGameTime() + (long)lookTime;
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new FreePositionTracker(entity.getEyePosition().add(Math.cos(angle), 0.0, Math.sin(angle))), (int)lookTime);
    }
}

