/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetAwayFrom<E extends BirdEntity, T>
extends SpeedModifiableBehaviour<E> {
    private final List<Pair<MemoryModuleType<?>, MemoryStatus>> memoryRequirements;
    protected final MemoryModuleType<T> memoryType;
    protected final Function<T, Vec3> targetPosition;

    public SetWalkTargetAwayFrom(MemoryModuleType<T> memoryType, Function<T, Vec3> targetPosition) {
        this.memoryType = memoryType;
        this.targetPosition = targetPosition;
        this.memoryRequirements = MemoryList.create(2).registered(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET).present((MemoryModuleType<?>)memoryType);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return this.memoryRequirements == null ? List.of() : this.memoryRequirements;
    }

    protected void start(E entity) {
        Vec3 distanceVec;
        Vec3 vec3d3;
        Brain brain = entity.getBrain();
        WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        Vec3 curPos = entity.position();
        Vec3 fleeTargetPos = this.targetPosition.apply(BrainUtils.getMemory((Brain)brain, this.memoryType));
        if (walkTarget != null && walkTarget.getSpeedModifier() == ((Float)this.speedModifier.apply(entity, walkTarget.getTarget().currentPosition())).floatValue() && (vec3d3 = walkTarget.getTarget().currentPosition().subtract(curPos)).dot(distanceVec = fleeTargetPos.subtract(curPos)) < 0.0) {
            return;
        }
        for (int j = 0; j < 10; ++j) {
            Vec3 target = LandRandomPos.getPosAway(entity, (int)16, (int)16, (Vec3)fleeTargetPos);
            if (target == null) continue;
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(target));
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(target, ((Float)this.speedModifier.apply(entity, target)).floatValue(), 0));
            break;
        }
    }
}

