/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SpeedModifiableBehaviour;
import aqario.fowlplay.common.entity.ai.navigation.BirdRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetWaterWalkTarget<E extends BirdEntity>
extends SpeedModifiableBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).absent((MemoryModuleType<?>)MemoryModuleType.WALK_TARGET);
    protected CylindricalRadius radius = new CylindricalRadius(32, 16);
    protected BiPredicate<E, Vec3> positionPredicate = (entity, pos) -> true;

    public SetWaterWalkTarget<E> radius(int radius) {
        return this.radius(radius, radius);
    }

    public SetWaterWalkTarget<E> radius(int xz, int y) {
        this.radius = new CylindricalRadius(xz, y);
        return this;
    }

    public SetWaterWalkTarget<E> walkTargetPredicate(BiPredicate<E, Vec3> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected void start(E entity) {
        Vec3 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
        } else {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, ((Float)this.speedModifier.apply(entity, targetPos)).floatValue(), 0));
        }
    }

    @Nullable
    protected Vec3 getTargetPos(E entity) {
        return BirdRandomPos.getWaterOrGround(entity, this.radius, this.radius);
    }
}

