/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.FowlPlaySensorTypes;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class AttackedSensor<E extends BirdEntity>
extends PredicateSensor<DamageSource, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ImmutableList.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.AVOID_TARGET, FowlPlayMemoryTypes.SEES_FOOD.get(), FowlPlayMemoryTypes.CANNOT_PICKUP_FOOD.get());

    public AttackedSensor() {
        super((damageSource, entity) -> true);
        this.setScanRate(bird -> 10);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return FowlPlaySensorTypes.ATTACKED.get();
    }

    protected void doTick(ServerLevel world, E bird) {
        Brain brain = bird.getBrain();
        DamageSource damageSource = bird.getLastDamageSource();
        if (damageSource == null) {
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY);
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY);
            return;
        }
        if (this.predicate().test(damageSource, bird)) {
            LivingEntity attacker2;
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY, (Object)damageSource);
            Entity entity = damageSource.getEntity();
            if (entity instanceof LivingEntity && (attacker2 = (LivingEntity)entity).isAlive() && attacker2.level() == bird.level()) {
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (Object)attacker2);
                AttackedSensor.onAttacked(bird, attacker2);
            }
            return;
        }
        BrainUtils.withMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, attacker -> {
            if (!attacker.isAlive() || attacker.level() != bird.level()) {
                BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY);
            }
        });
    }

    public static <T extends BirdEntity> void onAttacked(T bird, LivingEntity attacker) {
        Brain brain = bird.getBrain();
        BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryTypes.SEES_FOOD.get());
        if (attacker instanceof Player) {
            TrustingBirdEntity trustingBird;
            Player player = (Player)attacker;
            BrainUtils.setForgettableMemory((Brain)brain, FowlPlayMemoryTypes.CANNOT_PICKUP_FOOD.get(), (Object)true, (int)1200);
            if (bird instanceof TrustingBirdEntity && (trustingBird = (TrustingBirdEntity)bird).trusts(player)) {
                trustingBird.stopTrusting(player);
            }
        }
        if (attacker.getType() != bird.getType() && !bird.shouldAttack(attacker)) {
            Birds.alertOthers(bird, attacker);
        }
    }
}

