/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import aqario.fowlplay.core.FowlPlaySensorTypes;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.EntityFilteringSensor;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class AvoidTargetSensor<E extends BirdEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    public AvoidTargetSensor() {
        this.setScanRate(bird -> 10);
    }

    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.AVOID_TARGET;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(this.getMemory(), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, FowlPlayMemoryTypes.IS_AVOIDING.get());
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return FowlPlaySensorTypes.AVOID_TARGETS.get();
    }

    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, self) -> Birds.shouldAvoid(self, target);
    }

    @Nullable
    protected LivingEntity findMatches(E bird, NearestVisibleLivingEntities matcher) {
        return matcher.findClosest(target -> this.predicate().test((LivingEntity)target, (E)((Object)bird))).orElse(null);
    }

    protected void doTick(ServerLevel level, E bird) {
        LivingEntity avoidTarget = (LivingEntity)this.testForEntity((LivingEntity)bird);
        if (avoidTarget != null) {
            BrainUtils.setMemory(bird, this.getMemory(), (Object)avoidTarget);
        } else {
            BrainUtils.clearMemory(bird, this.getMemory());
        }
        if (avoidTarget != null && avoidTarget.closerThan(bird, (double)((BirdEntity)((Object)bird)).getFleeRange(avoidTarget))) {
            BrainUtils.setMemory(bird, FowlPlayMemoryTypes.IS_AVOIDING.get(), (Object)Unit.INSTANCE);
        } else {
            BrainUtils.clearMemory(bird, FowlPlayMemoryTypes.IS_AVOIDING.get());
        }
    }
}

