/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.navigation;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.navigation.ExtendedRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.TargetingUtil;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BirdRandomPos {
    @Nullable
    public static Vec3 getWaterOrGround(BirdEntity entity, CylindricalRadius waterRange, CylindricalRadius groundRange) {
        Vec3 pos = BirdRandomPos.getWater(entity, waterRange);
        return pos != null ? pos : BirdRandomPos.getGround(entity, groundRange);
    }

    @Nullable
    public static Vec3 getWater(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindWater((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getNonAir(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindNonAir((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getPerchOrGround(BirdEntity entity, CylindricalRadius perchRange, CylindricalRadius groundRange) {
        Vec3 pos = BirdRandomPos.getPerch(entity, perchRange);
        return pos != null ? pos : BirdRandomPos.getGround(entity, groundRange);
    }

    @Nullable
    public static Vec3 getGround(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindGround((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getPerch(BirdEntity entity, CylindricalRadius range) {
        return BirdRandomPos.getPerch(entity, range, pos -> 0.0);
    }

    @Nullable
    public static Vec3 getPerch(BirdEntity entity, CylindricalRadius range, ToDoubleFunction<BlockPos> scorer) {
        Vec3 direction = entity.getViewVector(1.0f);
        return RandomPos.generateRandomPos(() -> {
            BlockPos pos = TargetingUtil.tryFindPerch((PathfinderMob)entity, range, ExtendedRandomPos.generateWithinAnglePreferNear(entity.getRandom(), range.horizontal(), range.vertical(), 0, direction, 4.71238898038469));
            return TargetingUtil.validateBlockPos((PathfinderMob)entity, pos, range);
        }, scorer);
    }

    @Nullable
    public static Vec3 getAir(FlyingBirdEntity entity, CylindricalRadius range) {
        return BirdRandomPos.getAir(entity, range, entity::getFlyingWalkTargetValue);
    }

    @Nullable
    public static Vec3 getAir(FlyingBirdEntity entity, CylindricalRadius range, ToDoubleFunction<BlockPos> scorer) {
        Vec3 direction = entity.getViewVector(1.0f);
        double angle = 15.0;
        return RandomPos.generateRandomPos(() -> {
            BlockPos pos = TargetingUtil.tryFindAir((PathfinderMob)entity, range, ExtendedRandomPos.generateWithinAnglePreferFar(entity.getRandom(), range.horizontal(), range.vertical(), 0, direction, 0.2617993877991494));
            return TargetingUtil.validateBlockPos((PathfinderMob)entity, pos, range);
        }, scorer);
    }
}

