/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.navigation;

import java.util.function.DoubleUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class ExtendedRandomPos {
    public static BlockPos generatePreferFar(RandomSource random, int horizontalRange, int verticalRange) {
        return ExtendedRandomPos.generate(random, Math::sqrt, horizontalRange, verticalRange);
    }

    public static BlockPos generate(RandomSource random, DoubleUnaryOperator distanceFunction, int horizontalRange, int verticalRange) {
        double angle = random.nextDouble() * 6.2831854820251465;
        double dist = distanceFunction.applyAsDouble(random.nextDouble()) * (double)horizontalRange;
        double x = -dist * Math.sin(angle);
        double z = dist * Math.cos(angle);
        int y = random.nextInt(2 * verticalRange + 1) - verticalRange;
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    public static BlockPos generateWithinAnglePreferFar(RandomSource random, int horizontalRange, int verticalRange, int flyingHeight, Vec3 direction, double sliceAngle) {
        return ExtendedRandomPos.generateWithinAngle(random, Math::sqrt, 0, horizontalRange, verticalRange, flyingHeight, direction, sliceAngle);
    }

    public static BlockPos generateWithinAnglePreferNear(RandomSource random, int horizontalRange, int verticalRange, int flyingHeight, Vec3 direction, double sliceAngle) {
        return ExtendedRandomPos.generateWithinAngle(random, d -> Math.pow(d, 2.0), 0, horizontalRange, verticalRange, flyingHeight, direction, sliceAngle);
    }

    public static BlockPos generateWithinAngle(RandomSource random, DoubleUnaryOperator distanceFunction, int minHorizontalRange, int maxHorizontalRange, int verticalRange, int flyingHeight, Vec3 direction, double angle) {
        double directionAngle = Mth.atan2((double)direction.z, (double)direction.x) - 1.5707963705062866;
        double randomAngle = directionAngle + (double)(2.0f * random.nextFloat() - 1.0f) * angle;
        double randomDist = Mth.lerp((double)distanceFunction.applyAsDouble(random.nextDouble()), (double)minHorizontalRange, (double)maxHorizontalRange);
        double x = -randomDist * Math.sin(randomAngle);
        double z = randomDist * Math.cos(randomAngle);
        int y = random.nextInt(2 * verticalRange + 1) - verticalRange + flyingHeight;
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    public static BlockPos generateWithinCone(RandomSource random, int minRange, int maxRange, int startHeight, Vec3 direction, double coneAngle) {
        double baseHorizontalAngle = Math.atan2(direction.z, direction.x);
        double baseVerticalAngle = Math.asin(direction.y);
        double randomAngleOffset = (2.0 * random.nextDouble() - 1.0) * (coneAngle / 2.0);
        double rotationAngle = random.nextDouble() * 2.0 * Math.PI;
        double yaw = baseHorizontalAngle + randomAngleOffset * Math.cos(rotationAngle);
        double pitch = baseVerticalAngle + randomAngleOffset * Math.sin(rotationAngle);
        double randomDist = Mth.lerp((double)Math.sqrt(random.nextDouble()), (double)minRange, (double)maxRange);
        double randomHorizontalDist = randomDist * Math.cos(pitch);
        double x = randomHorizontalDist * Math.cos(yaw);
        double z = randomHorizontalDist * Math.sin(yaw);
        double y = randomDist * Math.sin(pitch) + (double)startHeight;
        return BlockPos.containing((double)x, (double)y, (double)z);
    }
}

