/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TargetingUtil {
    @Nullable
    public static BlockPos tryFindAir(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.getRandom(), (BlockPos)pos);
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)(adjustedPos = RandomPos.moveUpOutOfSolid((BlockPos)adjustedPos, (int)entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos)))) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.isNotStable((PathNavigation)entity.getNavigation(), (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindWater(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 0, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (!GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindNonAir(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionNonAir(entity, adjustedPos)) {
            return null;
        }
        return entity.level().isWaterAt(adjustedPos.below()) ? adjustedPos.below() : adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindGround(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionGrounded(entity, adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindPerch(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) && !TargetingUtil.isPerch(entity, currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos.below()) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPerch(entity, adjustedPos)) {
            return null;
        }
        return entity.level().getBlockState(adjustedPos).getBlock() instanceof LeavesBlock ? adjustedPos.below() : adjustedPos;
    }

    public static BlockPos findSurfacePosition(PathfinderMob entity, BlockPos initialPos, CylindricalRadius range, Heightmap.Types heightmap, int blocksAbove, Predicate<BlockPos> predicate) {
        BlockPos adjustedPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.getRandom(), (BlockPos)initialPos);
        adjustedPos = adjustedPos.getY() > entity.level().getHeight(heightmap, adjustedPos.getX(), adjustedPos.getZ()) ? new BlockPos(adjustedPos.getX(), entity.level().getHeight(heightmap, adjustedPos.getX(), adjustedPos.getZ()) + blocksAbove, adjustedPos.getZ()) : RandomPos.moveUpOutOfSolid((BlockPos)adjustedPos, (int)entity.level().getMaxBuildHeight(), predicate).above(blocksAbove - 1);
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validateBlockPos(PathfinderMob entity, @Nullable BlockPos pos, CylindricalRadius range) {
        if (pos == null) {
            return null;
        }
        if (GoalUtils.isOutsideLimits((BlockPos)pos, (PathfinderMob)entity) || GoalUtils.isRestricted((boolean)GoalUtils.mobRestricted((PathfinderMob)entity, (int)range.horizontal()), (PathfinderMob)entity, (BlockPos)pos)) {
            return null;
        }
        return pos;
    }

    @Nullable
    public static Vec3 validatePos(PathfinderMob entity, BlockPos pos, CylindricalRadius range) {
        BlockPos validPos = TargetingUtil.validateBlockPos(entity, pos, range);
        return validPos != null ? validPos.getBottomCenter() : null;
    }

    public static boolean isPerch(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).is(FowlPlayBlockTags.PERCHES);
    }

    public static boolean isPositionNonAir(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return TargetingUtil.isFullBlockAt(entity, belowPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)belowPos);
    }

    public static boolean isPositionGrounded(PathfinderMob entity, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return TargetingUtil.isFullBlockAt(entity, belowPos);
    }

    public static boolean isFullBlockAt(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).isSolidRender((BlockGetter)entity.level(), pos);
    }

    public static boolean isWithinAngle(Vec3 normalVec, Vec3 targetVec, double angle) {
        float cosMaxAngle;
        float cosVectorAngle = (float)(normalVec = normalVec.normalize()).dot(targetVec = targetVec.normalize());
        return cosVectorAngle >= (cosMaxAngle = Mth.cos((float)((float)angle)));
    }

    public static boolean isPosWithinViewAngle(PathfinderMob entity, BlockPos pos, double angle) {
        Vec3 lookVec = entity.getViewVector(1.0f);
        Vec3 target = Vec3.atCenterOf((Vec3i)pos);
        Vec3 targetVec = target.subtract(entity.position());
        return TargetingUtil.isWithinAngle(lookVec, targetVec, angle);
    }
}

