/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.path;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1314;
import net.minecraft.class_243;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5532;
import net.minecraft.class_5534;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetRandomWalkTarget<E extends class_1314>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(1).noMemory(class_4140.field_18445);
    protected BiFunction<E, class_243, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected Predicate<E> avoidWaterPredicate = entity -> true;
    protected SquareRadius radius = new SquareRadius(10.0, 7.0);
    protected BiPredicate<E, class_243> positionPredicate = (entity, pos) -> true;

    public SetRandomWalkTarget<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SetRandomWalkTarget<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SetRandomWalkTarget<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SetRandomWalkTarget<E> speedModifier(BiFunction<E, class_243, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SetRandomWalkTarget<E> walkTargetPredicate(BiPredicate<E, class_243> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    public SetRandomWalkTarget<E> dontAvoidWater() {
        return this.avoidWaterWhen(entity -> false);
    }

    public SetRandomWalkTarget<E> avoidWaterWhen(Predicate<E> predicate) {
        this.avoidWaterPredicate = predicate;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected void start(E entity) {
        class_243 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, class_4140.field_18445);
        } else {
            BrainUtils.setMemory(entity, class_4140.field_18445, new class_4142(targetPos, this.speedModifier.apply(entity, targetPos).floatValue(), 0));
        }
    }

    @Nullable
    protected class_243 getTargetPos(E entity) {
        if (this.avoidWaterPredicate.test(entity)) {
            return class_5534.method_31527(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
        }
        return class_5532.method_31510(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
    }
}

