/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.object;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SBLShufflingList<T>
implements Iterable<T> {
    private final List<WeightedEntry<T>> entries;
    private final class_5819 random = class_5819.method_43053();

    public SBLShufflingList() {
        this.entries = new ObjectArrayList();
    }

    public SBLShufflingList(int size) {
        this.entries = new ObjectArrayList(size);
    }

    @SafeVarargs
    public SBLShufflingList(Pair<T, Integer> ... entries) {
        this.entries = new ObjectArrayList(entries.length);
        for (Pair<T, Integer> entry : entries) {
            this.entries.add(new WeightedEntry<Object>(entry.getFirst(), (Integer)entry.getSecond()));
        }
    }

    public SBLShufflingList(Collection<Pair<T, Integer>> entries) {
        this.entries = new ObjectArrayList(entries.size());
        for (Pair<T, Integer> entry : entries) {
            this.entries.add(new WeightedEntry<Object>(entry.getFirst(), (Integer)entry.getSecond()));
        }
    }

    public SBLShufflingList<T> shuffle() {
        this.entries.forEach(entry -> entry.setShuffledWeight(this.random.method_43057()));
        this.entries.sort(Comparator.comparingDouble(WeightedEntry::getShuffledWeight));
        return this;
    }

    public boolean add(T entry, int weight) {
        return this.entries.add(new WeightedEntry<T>(entry, weight));
    }

    @Nullable
    public T get(int index) {
        return this.entries.get(index).get();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ObjectIterators.AbstractIndexBasedIterator<T>(0, 0){

            protected T get(int location) {
                return SBLShufflingList.this.entries.get(location).get();
            }

            protected void remove(int location) {
                SBLShufflingList.this.entries.remove(location);
            }

            protected int getMaxPos() {
                return SBLShufflingList.this.entries.size();
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.entries.forEach(entry -> action.accept((Object)entry.get()));
    }

    public Stream<T> stream() {
        return this.entries.stream().map(WeightedEntry::get);
    }

    public static class WeightedEntry<T> {
        private final T object;
        private final int weight;
        private double shuffledWeight;

        WeightedEntry(T object, int weight) {
            this.object = object;
            this.weight = weight;
        }

        double getShuffledWeight() {
            return this.shuffledWeight;
        }

        T get() {
            return this.object;
        }

        int getWeight() {
            return this.weight;
        }

        void setShuffledWeight(float mod) {
            this.shuffledWeight = -Math.pow(mod, 1.0f / (float)this.weight);
        }

        public String toString() {
            return String.valueOf(this.object) + ":" + this.weight;
        }
    }
}

