/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.navigation.FlightNavigation;
import aqario.fowlplay.common.entity.ai.navigation.GroundNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1408;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class FlyingBirdEntity
extends BirdEntity {
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(FlyingBirdEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 glidingState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    private boolean isFlightNavigation;
    private float prevRoll;
    private float roll;
    public int timeFlying = 0;
    private static final int ROLL_FACTOR = 4;
    private static final float MIN_HEALTH_TO_FLY = 1.5f;
    private static final int MIN_FLIGHT_TIME = 15;
    private static final double MIN_FLIGHT_VELOCITY = 0.1;
    private static final float MAX_ROLL_CHANGE = 20.0f;

    protected FlyingBirdEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.setNavigation(false);
        this.method_5941(class_7.field_6, 0.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_18, -1.0f);
    }

    public static class_5132.class_5133 createFlyingBirdAttributes() {
        return BirdEntity.createBirdAttributes().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.28f).method_26868(class_5134.field_23720, (double)0.235f);
    }

    private static boolean hasSkyAccess(class_1936 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    private static boolean isMidairSpawn(class_1936 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260()) <= pos.method_10264() - 32 && world.method_8320(pos.method_10074()).method_26215();
    }

    public static boolean canSpawnPasserines(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.method_8320(pos.method_10074()).method_26204() instanceof class_2397 && (Integer)world.method_8320(pos.method_10074()).method_11654((class_2769)class_2741.field_12541) < 7 || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnShorebirds(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.SHOREBIRDS_SPAWNABLE_ON) || world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnWaterfowl(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    protected class_1408 method_5965(class_1937 world) {
        this.setNavigation(this.isFlying());
        return this.field_6189;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLYING, (Object)false);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("flying", this.isFlying());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setFlying(nbt.method_10577("flying"));
    }

    protected void method_5801() {
        this.method_5783(FowlPlaySoundEvents.ENTITY_BIRD_FLAP.get(), this.getFlapVolume(), this.getFlapPitch());
    }

    public abstract float getFlapVolume();

    public abstract float getFlapPitch();

    public CylindricalRadius getWalkRange() {
        return new CylindricalRadius(16, 8);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.isFlying()) {
                ++this.timeFlying;
                this.method_5875(true);
                this.field_6017 = 0.0f;
                if (this.shouldStopFlying()) {
                    this.stopFlying();
                }
            } else {
                this.timeFlying = 0;
                this.method_5875(false);
            }
            if (this.isFlying() != this.isFlightNavigation) {
                this.setNavigation(this.isFlying());
            }
        }
        this.prevRoll = this.roll;
        this.roll = this.rollTowards(this.prevRoll, this.calculateRoll(this.field_5982, this.method_36454()));
    }

    protected float rollTowards(float from, float to) {
        float diff = class_3532.method_15381((float)from, (float)to);
        float angle = class_3532.method_15363((float)diff, (float)-20.0f, (float)20.0f);
        return from + angle;
    }

    private float calculateRoll(float prevYaw, float currentYaw) {
        float difference = currentYaw - prevYaw;
        if (difference >= 180.0f) {
            difference = 360.0f - difference;
        }
        if (difference < -180.0f) {
            difference = -(360.0f + difference);
        }
        return -difference * 4.0f;
    }

    public float getRoll(float tickDelta) {
        return tickDelta == 1.0f ? this.roll : class_3532.method_16439((float)tickDelta, (float)this.prevRoll, (float)this.roll);
    }

    @Override
    protected void updateAnimations() {
        if (!this.isFlying() && !this.method_5816()) {
            if (this.field_5974.method_43048(1000) < this.idleAnimationChance++ && !this.isMoving()) {
                this.resetIdleAnimationDelay();
                this.standingState.method_41325();
                this.idleAnimStates.stopAll();
                this.idleAnimStates.startRandom(this.field_6012);
            } else if (this.isMoving()) {
                this.idleAnimStates.stopAll();
            }
            if (!this.idleAnimStates.containsStarted()) {
                this.standingState.method_41324(this.field_6012);
            } else {
                this.standingState.method_41325();
            }
        } else {
            this.standingState.method_41325();
            this.idleAnimStates.stopAll();
        }
        this.glidingState.method_45317(this.isFlying(), this.field_6012);
        this.swimmingState.method_45317(this.method_5816() && !this.isFlying(), this.field_6012);
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    protected class_1408 getLandNavigation() {
        return new GroundNavigation((class_1308)this, this.method_37908());
    }

    protected FlightNavigation getFlightNavigation() {
        FlightNavigation navigation = new FlightNavigation(this, this.method_37908());
        navigation.method_6363(false);
        navigation.method_35139(true);
        navigation.method_6354(this.canSwim());
        return navigation;
    }

    public int getMaxPitchChange() {
        return 20;
    }

    public int getMaxYawChange() {
        return 20;
    }

    @Override
    public int method_20240() {
        return this.isFlying() ? 10 : super.method_20240();
    }

    protected boolean canSwim() {
        return false;
    }

    public void setNavigation(boolean isFlying) {
        if (isFlying) {
            this.field_6189 = this.getFlightNavigation();
            this.isFlightNavigation = true;
        } else {
            this.field_6189 = this.getLandNavigation();
            this.isFlightNavigation = false;
        }
    }

    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)5, (Object)10);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (!this.isFlying()) {
            return super.method_6144(pos, world);
        }
        return this.getFlyingWalkTargetValue(pos, world);
    }

    public float getFlyingWalkTargetValue(class_2338 pos) {
        return this.getFlyingWalkTargetValue(pos, (class_4538)this.method_37908());
    }

    public float getFlyingWalkTargetValue(class_2338 pos, class_4538 world) {
        return FlyingBirdEntity.magicFunction(pos.method_10264() - world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()), this.getFlyHeightRange());
    }

    private static float magicFunction(float posY, Pair<Integer, Integer> flyHeightRange) {
        if (posY < (float)((Integer)flyHeightRange.getFirst()).intValue()) {
            return posY - (float)((Integer)flyHeightRange.getFirst()).intValue();
        }
        if (posY > (float)((Integer)flyHeightRange.getSecond()).intValue()) {
            return (float)((Integer)flyHeightRange.getSecond()).intValue() - posY;
        }
        return 0.0f;
    }

    protected float method_49484() {
        return this.isFlying() ? this.method_6029() : super.method_49484();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return !this.isFlying() && super.method_5747(fallDistance, damageMultiplier, damageSource);
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        if (!this.isFlying()) {
            super.method_5623(heightDifference, onGround, landedState, landedPosition);
        }
    }

    protected boolean method_5860(class_1297 entity) {
        return !this.isFlying() && super.method_5860(entity);
    }

    public boolean canStartFlying() {
        return !this.isFlying() && !this.isBelowWaterline() && this.method_6032() >= 1.5f;
    }

    public boolean shouldStopFlying() {
        if (this.method_5869() || this.method_5765()) {
            return true;
        }
        if (this.timeFlying < 15) {
            return false;
        }
        return this.method_24828() || this.isBelowWaterline() || this.method_18798().method_1033() < 0.1 || this.method_6032() < 1.5f;
    }

    public void startFlying() {
        this.setFlying(true);
        this.setNavigation(true);
    }

    public void stopFlying() {
        this.setFlying(false);
        this.setNavigation(false);
        this.method_5942().method_6340();
        class_4095 brain = this.method_18868();
        brain.method_18875(class_4140.field_18445);
        if (Birds.isNotFlightless((class_1297)this) && Birds.isPerched(this)) {
            this.method_18799(class_243.field_1353);
            this.method_5942().method_6340();
        }
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    @VisibleForTesting
    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    protected void method_51296(class_2680 state) {
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected void method_49787(class_2680 primaryState, class_2680 secondaryState) {
    }

    @Override
    protected boolean canSing() {
        return Birds.isPerched(this) && super.canSing();
    }

    public void method_29242(boolean flutter) {
        float speed;
        float yDelta = (float)(this.method_23318() - this.field_6036);
        float posDelta = !this.isFlying() || yDelta > 0.0f ? (float)class_3532.method_33825((double)(this.method_23317() - this.field_6014), (double)0.0, (double)(this.method_23321() - this.field_5969)) : (float)class_3532.method_33825((double)(this.method_23317() - this.field_6014), (double)yDelta, (double)(this.method_23321() - this.field_5969));
        if (this.isFlying()) {
            speed = Math.abs(1.0f - Math.min(posDelta * 0.8f, 1.0f));
            if (yDelta > 0.0f) {
                speed = (float)Math.sqrt(speed * speed + yDelta * yDelta * 4.0f);
            }
        } else {
            speed = Math.min(posDelta * 4.0f, 1.0f);
        }
        this.field_42108.method_48568(speed, 0.4f);
    }

    protected void method_48565(float posDelta) {
    }

    public void method_6091(class_243 movementInput) {
        if (!this.isFlying()) {
            super.method_6091(movementInput);
            return;
        }
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(this.isBelowWaterline() ? 0.02f : this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else {
                float friction = 0.75f;
                this.method_5724(this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)friction));
            }
        }
        this.method_29242(false);
    }
}

