/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.NotNull;

public class AnimationStateList
implements Iterable<class_7094> {
    private final List<Entry> entries;
    private final class_5819 random = class_5819.method_43053();

    public AnimationStateList() {
        this.entries = new ObjectArrayList();
    }

    public AnimationStateList with(class_7094 entry, int weight) {
        this.entries.add(new Entry(entry, weight));
        return this;
    }

    public AnimationStateList randomize() {
        this.entries.forEach((? super T entry) -> entry.randomizeWeight(this.random.method_43057()));
        this.entries.sort(Comparator.comparingDouble(Entry::getRandomizedWeight));
        return this;
    }

    public void startRandom(int tickCount) {
        this.randomize().getFirst().ifPresent(animState -> animState.method_41322(tickCount));
    }

    @NotNull
    public Optional<class_7094> getFirst() {
        return Optional.ofNullable(this.entries.isEmpty() ? null : this.entries.getFirst()).map(Entry::getState);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean containsStarted() {
        for (class_7094 state : this) {
            if (state == null || !state.method_41327()) continue;
            return true;
        }
        return false;
    }

    public void stopAll() {
        this.forEach((Consumer<? super class_7094>)((Consumer<class_7094>)class_7094::method_41325));
    }

    @Override
    public void forEach(Consumer<? super class_7094> action) {
        this.entries.forEach((? super T entry) -> {
            if (entry.getState() != null) {
                action.accept(entry.getState());
            }
        });
    }

    @Override
    @NotNull
    public Iterator<class_7094> iterator() {
        return new ObjectIterators.AbstractIndexBasedIterator<class_7094>(0, 0){

            protected class_7094 get(int location) {
                return AnimationStateList.this.entries.get(location).getState();
            }

            protected void remove(int location) {
                AnimationStateList.this.entries.remove(location);
            }

            protected int getMaxPos() {
                return AnimationStateList.this.entries.size();
            }
        };
    }

    public static class Entry {
        private final class_7094 state;
        private final int weight;
        private double randomizedWeight;

        protected Entry(class_7094 state, int weight) {
            this.state = state;
            this.weight = weight;
        }

        protected double getRandomizedWeight() {
            return this.randomizedWeight;
        }

        protected class_7094 getState() {
            return this.state;
        }

        protected int getWeight() {
            return this.weight;
        }

        protected void randomizeWeight(float mod) {
            this.randomizedWeight = -Math.pow(mod, 1.0f / (float)this.weight);
        }

        public String toString() {
            return String.valueOf(this.state) + ":" + this.weight;
        }
    }
}

