/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.Villager;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SecondaryPoiSensor<E extends Villager>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26363_});
    protected SquareRadius radius = new SquareRadius(8.0, 4.0);

    public SecondaryPoiSensor() {
        this.setScanRate(entity -> 40);
    }

    public SecondaryPoiSensor<E> setRadius(int radius) {
        return this.setRadius(radius, radius);
    }

    public SecondaryPoiSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.SECONDARY_POI.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        ResourceKey dimension = level.m_46472_();
        BlockPos pos = entity.m_20183_();
        ImmutableSet testPoiBlocks = entity.m_7141_().m_35571_().f_35603_();
        ObjectArrayList poiPositions = new ObjectArrayList();
        if (testPoiBlocks.isEmpty()) {
            return;
        }
        for (BlockPos testPos : BlockPos.m_121976_((int)(pos.m_123341_() - (int)this.radius.xzRadius() / 2), (int)(pos.m_123342_() - (int)this.radius.yRadius() / 2), (int)(pos.m_123343_() - (int)this.radius.xzRadius() / 2), (int)(pos.m_123341_() + (int)this.radius.xzRadius() / 2), (int)(pos.m_123342_() + (int)this.radius.yRadius() / 2), (int)(pos.m_123343_() + (int)this.radius.xzRadius() / 2))) {
            if (!testPoiBlocks.contains((Object)level.m_8055_(testPos).m_60734_())) continue;
            poiPositions.add(GlobalPos.m_122643_((ResourceKey)dimension, (BlockPos)testPos.m_7949_()));
        }
        if (poiPositions.isEmpty()) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26363_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.f_26363_, poiPositions);
        }
    }
}

