/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.HawkAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HawkModel
extends FlyingBirdModel<HawkEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("hawk"), "main");

    public HawkModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition root = modelPartData.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)1.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -0.75f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 3).m_171488_(-0.5f, -0.25f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)).m_171514_(0, 6).m_171488_(-0.5f, 0.0f, -2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)-1.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 1).m_171488_(-2.0f, -2.9021f, -6.3154f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(16, 12).m_171488_(-2.0f, -2.9021f, 0.6846f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.9021f, (float)2.3154f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        torso.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, -3.0f, -3.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.4021f, (float)-2.3154f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, -1.0f, -0.75f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)-4.0f, (float)-0.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171480_().m_171488_(-1.0f, -1.0f, -0.75f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.75f, (float)-4.0f, (float)-0.25f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.m_171599_("left_wing_open", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-1.0f, 0.0f, -1.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-4.5f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        left_wing_open.m_171599_("left_wing_outer", CubeListBuilder.m_171558_().m_171514_(19, 10).m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)-1.5f));
        PartDefinition right_wing_open = body.m_171599_("right_wing_open", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171480_().m_171488_(-8.0f, 0.0f, -1.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)-4.5f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        right_wing_open.m_171599_("right_wing_outer", CubeListBuilder.m_171558_().m_171514_(19, 10).m_171480_().m_171488_(-10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)-1.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171488_(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(49, 0).m_171488_(-1.5f, -0.5f, 3.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(19, 0).m_171488_(-1.0f, -0.503f, 1.5f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)3.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        tail.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-1.0f, 0.999f, -1.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        tail.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-1.0f, 0.998f, -1.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        tail.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171480_().m_171488_(-1.0f, 0.998f, -1.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        tail.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171480_().m_171488_(-1.0f, 0.999f, -1.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)-1.5f, (float)2.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(21, 4).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)).m_171514_(15, 4).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(15, 4).m_171480_().m_171488_(-1.0f, 4.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.5f, (float)1.0f, (float)2.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(21, 4).m_171480_().m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.001f)).m_171555_(false).m_171514_(15, 4).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(15, 4).m_171488_(-1.0f, 4.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)1.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void prepareMobModel(HawkEntity hawk, float limbAngle, float limbDistance, float tickDelta) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        super.m_6839_((Entity)hawk, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)hawk.f_19797_ + tickDelta;
        float bodyYaw = Mth.m_14189_((float)tickDelta, (float)hawk.f_20884_, (float)hawk.f_20883_);
        float headYaw = Mth.m_14189_((float)tickDelta, (float)hawk.f_20886_, (float)hawk.f_20885_);
        float relativeHeadYaw = Mth.m_14177_((float)(headYaw - bodyYaw));
        float headPitch = Mth.m_14179_((float)tickDelta, (float)hawk.f_19860_, (float)hawk.m_146909_());
        if (LivingEntityRenderer.m_194453_((LivingEntity)hawk)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!hawk.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (hawk.isFlying()) {
            this.root.f_104203_ = hawk.m_5686_(tickDelta) * ((float)Math.PI / 180);
            this.root.f_104205_ = hawk.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (hawk.isFlying() || hawk.m_20072_()) {
            this.leftWingOpen.f_104207_ = true;
            this.rightWingOpen.f_104207_ = true;
            this.leftWing.f_104207_ = false;
            this.rightWing.f_104207_ = false;
        } else {
            this.leftWingOpen.f_104207_ = false;
            this.rightWingOpen.f_104207_ = false;
            this.leftWing.f_104207_ = true;
            this.rightWing.f_104207_ = true;
        }
        if (hawk.isFlying()) {
            this.m_267799_(HawkAnimations.FLAPPING, limbAngle, limbDistance, 1.5f, 1.5f);
        } else if (!hawk.m_20072_()) {
            this.m_267799_(HawkAnimations.WALKING, limbAngle, limbDistance, 2.5f, 4.0f);
        }
        this.m_233381_(hawk.standingState, HawkAnimations.STANDING, ageInTicks);
        this.m_233381_(hawk.swimmingState, HawkAnimations.SWIMMING, ageInTicks);
        this.m_233381_(hawk.glidingState, HawkAnimations.GLIDING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.m_14036_((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.neck.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

