/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class RobinEntity
extends FlyingBirdEntity
implements BirdBrain<RobinEntity>,
VariantHolder<Variant> {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(RobinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public RobinEntity(EntityType<? extends RobinEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.475f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)Variant.AMERICAN.toString());
    }

    public Variant getVariant() {
        return Variant.valueOf((String)this.f_19804_.m_135370_(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.toString());
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("variant", this.getVariant().toString());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("variant")) {
            this.setVariant(Variant.valueOf(nbt.m_128461_("variant")));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.m_204132_(FowlPlayItemTags.ROBIN_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.m_6095_().m_204039_(FowlPlayEntityTypeTags.ROBIN_AVOIDS);
    }

    @Override
    public void updateAnimations() {
        this.standingState.m_246184_(!this.isFlying() && !this.m_20072_(), this.f_19797_);
        this.flappingState.m_246184_(this.isFlying(), this.f_19797_);
        this.swimmingState.m_246184_(!this.isFlying() && this.m_20072_(), this.f_19797_);
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_ROBIN_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_ROBIN_SONG.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().robinCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().robinSongVolume;
    }

    @Override
    public int getCallDelay() {
        return 180;
    }

    @Override
    public int getSongDelay() {
        return 480;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_ROBIN_HURT.get();
    }

    protected Brain.Provider<RobinEntity> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends RobinEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor()});
    }

    public BrainActivityGroup<? extends RobinEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid(), FlightBehaviours.stopFalling(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runFor(entity -> entity.m_217043_().m_216332_(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends RobinEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends RobinEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends RobinEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends RobinEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeBehaviours.tryPickUpFood()});
    }

    @Override
    public BrainActivityGroup<? extends RobinEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    public static enum Variant {
        AMERICAN("american"),
        REDBREAST("redbreast");

        private final String id;

        private Variant(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

