/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class GuidedFlocking
extends ExtendedBehaviour<FlyingBirdEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(3).present((MemoryModuleType<?>)FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get()).absent(FowlPlayMemoryTypes.IS_AVOIDING.get(), FowlPlayMemoryTypes.SEES_FOOD.get());
    private static final int VIEW_RADIUS = 8;
    public float coherence;
    public float alignment;
    public final float separation;
    public final float separationRange;
    private FlyingBirdEntity leader;
    private List<? extends AgeableMob> nearbyBirds;

    public GuidedFlocking(float separation, float separationRange) {
        this.separation = separation;
        this.separationRange = separationRange;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, FlyingBirdEntity bird) {
        if (!bird.isFlying()) {
            return false;
        }
        Brain brain = bird.m_6274_();
        if (!BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get())) {
            return false;
        }
        this.nearbyBirds = (List)BrainUtils.getMemory((Brain)brain, FowlPlayMemoryTypes.NEAREST_VISIBLE_ADULTS.get());
        assert (this.nearbyBirds != null);
        this.nearbyBirds.removeIf(entity -> entity.m_20280_((Entity)bird) > 64.0);
        if (this.nearbyBirds.isEmpty()) {
            return false;
        }
        this.leader = null;
        this.nearbyBirds.forEach(entity -> {
            Flocking flockingBird;
            if (entity instanceof Flocking && (flockingBird = (Flocking)entity).isLeader()) {
                this.leader = (FlyingBirdEntity)((Object)((Object)flockingBird));
            }
        });
        if (this.leader == null) {
            ((Flocking)((Object)bird)).setLeader();
            return false;
        }
        return true;
    }

    protected boolean canStillUse(ServerLevel world, FlyingBirdEntity bird, long time) {
        return this.checkExtraStartConditions(world, bird);
    }

    protected void tick(FlyingBirdEntity bird) {
        Vec3 heading = this.getHeading(bird).m_82549_(bird.m_20182_());
        bird.m_21566_().m_6849_(heading.f_82479_, heading.f_82480_, heading.f_82481_, (double)(bird.m_217043_().m_188501_() - bird.m_217043_().m_188501_()) * 1.5 + 2.0);
    }

    private Vec3 getHeading(FlyingBirdEntity bird) {
        Vec3 separation = Vec3.f_82478_;
        Vec3 alignment = Vec3.f_82478_;
        Vec3 cohesion = Vec3.f_82478_;
        for (AgeableMob ageableMob : this.nearbyBirds) {
            if (ageableMob.m_20182_().m_82546_(bird.m_20182_()).m_82553_() < (double)this.separationRange) {
                separation = separation.m_82546_(ageableMob.m_20182_().m_82546_(bird.m_20182_()));
            }
            alignment = alignment.m_82549_(ageableMob.m_20184_());
            cohesion = cohesion.m_82549_(ageableMob.m_20182_());
        }
        alignment = alignment.m_82490_((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.m_82490_((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.m_82546_(bird.m_20182_());
        cohesion = cohesion.m_82490_((double)this.coherence);
        alignment = alignment.m_82490_((double)this.alignment);
        separation = separation.m_82490_((double)this.separation);
        Vec3 randomness = new Vec3((double)(bird.m_217043_().m_188501_() - bird.m_217043_().m_188501_()), (double)(bird.m_217043_().m_188501_() - bird.m_217043_().m_188501_()), (double)(bird.m_217043_().m_188501_() - bird.m_217043_().m_188501_())).m_82490_(0.5);
        return cohesion.m_82549_(separation).m_82549_(alignment).m_82549_(randomness);
    }
}

