/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class NearbyFoodSensor<E extends BirdEntity>
extends PredicateSensor<ItemEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()});

    public NearbyFoodSensor() {
        super((item, bird) -> bird.m_7243_(item.m_32055_()) && bird.m_142582_((Entity)item));
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_ITEMS.get();
    }

    protected void doTick(ServerLevel world, E bird) {
        Brain brain = bird.m_6274_();
        double radius = bird.m_21133_(Attributes.f_22277_);
        List nearbyItems = EntityRetrievalUtil.getEntities(bird, (double)radius, entity -> {
            if (!(entity instanceof ItemEntity)) return false;
            ItemEntity item = (ItemEntity)entity;
            if (!this.predicate().test(item, bird)) return false;
            return true;
        });
        BrainUtils.setMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()), (Object)nearbyItems);
        if (Birds.canPickupFood(bird)) {
            BrainUtils.setMemory((Brain)brain, FowlPlayMemoryTypes.SEES_FOOD.get(), (Object)Unit.INSTANCE);
        } else {
            BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryTypes.SEES_FOOD.get());
        }
    }
}

